unit gsound_editor ;

interface

uses
  Dialogs, GSound, DsgnIntf ;

type
  TGLSoundButtonEditor = class(TComponentEditor)
     function GetVerbCount : integer ; override ;
     function GetVerb(Index : integer) : string ; override ;
     procedure ExecuteVerb(Index : integer) ; override ;
  end ;

  TWavFileNameEditor = class(TStringProperty)
    function  GetAttributes : TPropertyAttributes; override;
    procedure Edit ; override;
  end;

procedure Register;

implementation

function TWavFileNameEditor.GetAttributes : TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] ;
end;

procedure TWavFileNameEditor.Edit ;
var
   d : TOpenDialog ;
begin
  d := TOpenDialog.Create(nil) ;
  d.Title := 'Select a sound file' ;
  d.Filter := 'Sound files (*.wav)|*.wav|MIDI files (*.mid)|*.mid' ;
  d.FileName := GetStrValue ;
  if d.Execute then
     SetStrValue(d.FileName) ;
  d.Free ;
end;

{ component editor logic begins here }

function TGLSoundButtonEditor.GetVerbCount : integer ;
begin
     Result := 1 ;
end ;

function TGLSoundButtonEditor.GetVerb(Index : integer) : string ;
begin
     case Index of
        0 : Result := '&Test' ;
     end ;
end ;

procedure TGLSoundButtonEditor.ExecuteVerb(Index : integer) ;
begin
     case Index of
       0: (Component as TGLSoundButton).Play ;
     end ;
end ;

{ end component editor logic }

procedure Register;
begin
  RegisterPropertyEditor( TypeInfo(TWavFilename), TGLSoundButton,
                          'FileName', TWavFileNameEditor );
  RegisterComponentEditor(TGLSoundButton, TGLSoundButtonEditor) ;
end;

end.
