unit glsmenu_editor;

interface

uses
  Forms, DsgnIntf, Glsmenu, Windows ;

type
  TGLSysMenuEditor = class(TComponentEditor)
     function GetVerbCount : integer ; override ;
     function GetVerb(i : integer) : string ; override ;
     procedure ExecuteVerb(i : integer) ; override ;
  end ;

procedure Register;

implementation

function TGLSysMenuEditor.GetVerbCount : integer ;
begin
     Result := 1 ;
end ;

function TGLSysMenuEditor.GetVerb(i : integer) : string ;
begin
     if i = 0 then
        Result := '&Preview' ;
end ;

procedure TGLSysMenuEditor.ExecuteVerb(i : integer) ;
begin
     if i = 0 then
        with (Component as TGLSysMenu) do begin
           GetSystemMenu((Owner as TForm).Handle, True) ;
           GetSystemMenu(Application.Handle, True) ;
           RegisterMenuItems ;
        end ;
end ;

procedure Register;
begin
  RegisterComponentEditor(TGLSysMenu, TGLSysMenuEditor) ;
end;

end.
