unit glqbe_editor ;

interface

uses
  controls,
  forms,
  GLQBE,
  DsgnIntf, // for TComponentEditor
  FD_Form  // for TGLFieldSelectionDialog
  ;

type
  TGLQBEEditor = class(TComponentEditor)
     function GetVerbCount : integer ; override ;
     function GetVerb(Index : integer) : string ; override ;
     procedure ExecuteVerb(Index : integer) ; override ;
  end ;

procedure Register;

implementation

{ begin component editor logic }

function TGLQBEEditor.GetVerbCount : integer ;
begin
     Result := 1 ;
end ;

function TGLQBEEditor.GetVerb(Index : integer) : string ;
begin
     case Index of
        0 : Result := '&Edit Fields' ;
     end ;
end ;

procedure TGLQBEEditor.ExecuteVerb(Index : integer) ;
var
  f : TGLFieldSelectionDialog ;
begin
     case Index of

       0: begin
             f := TGLFieldSelectionDialog.Create(nil) ;
             f.ListBox.Items.Assign( (Component as TGLQBE).Fields ) ;
             { In the event that the developer wants to insert fields
               in the list, we must have access to the appropriate dataset.
               Making this a property of the ensuing dialog was the
               cleanest way that I could think of to accomplish this. }
             f.DataSet := (Component as TGLQBE).DataSet ;
             try
                if f.ShowModal = mrOK then
                   with (Component as TGLQBE) do begin
                      Fields.Assign( f.ListBox.Items ) ;
                      Designer.Modified ;
                   end ;
             finally ;
                f.Release ;
             end ;
          end ;
    end ;
end ;

{ end component editor logic }

procedure Register;
begin
  RegisterComponentEditor(TGLQBE, TGLQBEEditor) ;
end;

end.
