unit glmtable_editor ;

interface

uses
  DB, glmtable, Dialogs, DsgnIntf ;

type
  TGLModifyTableEditor = class(TComponentEditor)
     function GetVerbCount : integer ; override ;
     function GetVerb(i : integer) : string ; override ;
     procedure ExecuteVerb(i : integer) ; override ;
  end ;

procedure Register;

implementation

{ begin component editor logic }

function TGLModifyTableEditor.GetVerbCount : integer ;
begin
     with (Component as TGLModifyTable) do begin
        if Table = nil then
           Result := 0
        else begin
           Result := 2 ;
           if (FieldName <> '') and ( (Mode <> mtAddField) or (DataType <> ftUnknown) ) then
              Inc(Result) ;
           if PendingActions then
              Inc(Result) ;
        end ;      
     end ;
end ;

function TGLModifyTableEditor.GetVerb(i : integer) : string ;
const
     EXECUTE_PENDING_ACTIONS = 'Execute &Pending Actions' ;
begin
     case i of
        0 : Result := '&Pack Table' ;
        1 : begin
               if (Component as TGLModifyTable).Password <> '' then
                  Result := 'Add'
               else
                  Result := 'Remove' ;
               Result := Result + ' Pass&word' ;
            end ;
        2 : with (Component as TGLModifyTable) do begin
               if FieldName <> '' then begin
                  case Mode of
                     mtAddField    : Result := 'Add field ' + FieldName ;
                     mtChangeField : Result := 'Change field ' + FieldName ;
                     mtDeleteField : Result := 'Delete field ' + FieldName ;
                  end ;
               end
               else
                  Result := EXECUTE_PENDING_ACTIONS ;
            end ;
        3 : Result := EXECUTE_PENDING_ACTIONS ;
     end ;
end ;

procedure TGLModifyTableEditor.ExecuteVerb(i : integer) ;
type
   TGLModifyTableEditorFeedback = (mtefNone, mtefFailure, mtefSuccess,
                                   mtefPack, mtefPasswordAdded,
                                   mtefPasswordRemoved ) ;
var
   Feedback : TGLModifyTableEditorFeedback ;
begin
     Feedback := mtefNone ;

     case i of
        0 : begin
               if (Component as TGLModifyTable).PackTable then
                  Feedback := mtefPack
               else
                  Feedback := mtefFailure ;
            end ;
        1 :
               if (Component as TGLModifyTable).AddPassword then begin
                  if (Component as TGLModifyTable).Password <> '' then
                     Feedback := mtefPasswordAdded
                  else
                     Feedback := mtefPasswordRemoved
               end
               else
                  Feedback := mtefFailure ;
            //end ;
        2 : if (Component as TGLModifyTable).FieldName <> '' then begin
               // if operation is successful, clear field name in object inspector
               if (Component as TGLModifyTable).Execute then begin
                  (Component as TGLModifyTable).FieldName := '' ;
                  Designer.Modified ;
                  if mtoAutoCreate in (Component as TGLModifyTable).Options then
                     Feedback := mtefSuccess ;
               end ;
            end
            else
               Feedback := TGLModifyTableEditorFeedback(
                           Ord( (Component as TGLModifyTable).ExecutePendingActions ) + 1 ) ;
        3 : Feedback := TGLModifyTableEditorFeedback(
                        Ord( (Component as TGLModifyTable).ExecutePendingActions ) + 1 ) ;
     end ;

     case Feedback of
        mtefFailure         : MessageDlg( 'Could not modify/pack ' +
                                          (Component as TGLModifyTable).Table.TableName + #13 +
                                          'Error: ' + (Component as TGLModifyTable).LastError,
                                           mtError, [mbOK], 0) ;
        mtefSuccess         : MessageDlg( (Component as TGLModifyTable).Table.TableName +
                                          ' successfully modified', mtInformation, [mbOK], 0) ;
        mtefPack            : MessageDlg( (Component as TGLModifyTable).Table.TableName +
                                          ' successfully packed', mtInformation, [mbOK], 0) ;
        mtefPasswordAdded :   MessageDlg( 'Master password successfully added to ' +
                                          (Component as TGLModifyTable).Table.TableName,
                                          mtInformation, [mbOK], 0) ;
        mtefPasswordRemoved : MessageDlg( 'Master password successfully removed from ' +
                                          (Component as TGLModifyTable).Table.TableName,
                                          mtInformation, [mbOK], 0) ;
     end ;

end ;

{ end component editor logic }

procedure Register;
begin
  RegisterComponentEditor(TGLModifyTable, TGLModifyTableEditor) ;
end;

end.
