unit glanchor ;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ShellAPI ;

type
  TGLAnchor = class(TComponent)
  private
     FAllowMove : boolean ;
     FAllowResize : boolean ;
     FOldWindowProc : TWndMethod ;
     procedure NewWindowProc(var Message: TMessage) ;
  public
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
  published
     property AllowMove : boolean read FAllowMove write FAllowMove default True ;
     property AllowResize : boolean read FAllowResize write FAllowResize default True ;
  end;

procedure Register;

implementation

constructor TGLAnchor.Create(AOwner : TComponent) ;
begin
     inherited ;
     FAllowMove := True ;
     FAllowResize := True ;
     if not (csDesigning in ComponentState) then begin
        FOldWindowProc := (Owner as TForm).WindowProc ;
        (Owner as TForm).WindowProc := NewWindowProc ;
     end ;
end ;

destructor TGLAnchor.Destroy ;
begin
     if (not (csDesigning in ComponentState)) and (Owner <> nil) then
        (Owner as TForm).WindowProc := FOldWindowProc ;
     inherited ;
end ;

procedure TGLAnchor.NewWindowProc(var Message: TMessage);
begin
     if Message.Msg = WM_WINDOWPOSCHANGING then
        with PWindowPos(Message.LParam)^ do begin
           if not FAllowMove then
              Flags := Flags or SWP_NOMOVE ;
           if not FAllowResize then
              Flags := Flags or SWP_NOSIZE ;
        end
     else
        FOldWindowProc(Message) ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Interface', [TGLAnchor]);
end;

end.
