unit GGrad ;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TGradColor = (gcAqua, gcBlue, gcGreen, gcPurple, gcRed, gcWhite, gcYellow) ;
  TGradDirection = (gdDown, gdUp) ;

  TGLGradient = class(TGraphicControl)
  private
    FBackColor : TGradColor ;
    FDirection : TGradDirection ;
    FBC: array[0..255] of Longint;       { precalculated Brush.Colors }
    procedure WMEraseBkgnd(var Message: TWMEraseBkgnd); message wm_EraseBkgnd;
    procedure SetColor(v : TGradColor) ;
    procedure SetDirection(v : TGradDirection) ;
    procedure LoadColors ;
  protected
    procedure Paint; override;
  public
    constructor Create(AComponent: TComponent); override;
  published
    property BackColor : TGradColor read FBackColor write SetColor default gcBlue ;
    property Direction : TGradDirection read FDirection write SetDirection default gdDown ;
  end;

procedure Register;

implementation

constructor TGLGradient.Create(AComponent: TComponent);
begin
   inherited ;
   Align := alClient;
   FBackColor := gcBlue ;
   FDirection := gdDown ;
   LoadColors ;
{$IFDEF SHOW_COPYRIGHT}
   ShowCopyright(self,True) ;
{$ENDIF}
end;

procedure TGLGradient.LoadColors ;
var
  X, Y: Integer;
begin
     if FDirection = gdDown then
        Y := 255
     else
        Y := 0 ;

     for X := 0 to 255 do begin
        case FBackColor of
           gcAqua   : FBC[X] := RGB( 0, Y, Y );
           gcBlue   : FBC[X] := RGB( 0, 0, Y );
           gcGreen  : FBC[X] := RGB( 0, Y, 0 );
           gcPurple : FBC[X] := RGB( Y, 0, Y );
           gcRed    : FBC[X] := RGB( Y, 0, 0 );
           gcWhite  : FBC[X] := RGB( Y, Y, Y );
           gcYellow : FBC[X] := RGB( Y, Y, 0 );
        end ;
        if FDirection = gdDown then
           Dec(Y)
        else
           Inc(Y) ;
     end;
end ;

procedure TGLGradient.SetColor(v : TGradColor) ;
begin
     FBackColor := v ;
     LoadColors ;
     Paint ;
end ;

procedure TGLGradient.SetDirection(v : TGradDirection) ;
begin
     FDirection:= v ;
     LoadColors ;
     Paint ;
end ;

procedure TGLGradient.WMEraseBkgnd(var Message: TWMEraseBkgnd);
begin
  Message.Result := 1;   { do not allow Windows to erase it since it }
end;                     { is going to completely redraw itself anyway.}

procedure TGLGradient.Paint;
var
  TempRect   : TRect   ;
  TempStepV  : Single  ;
  ColorCode  : Integer ;
  TempTop    : Integer ;
  TempHeight : Integer ;
begin
  TempStepV := Height / 255;
  TempHeight := Trunc(TempStepV + 1); { round up to ensure overlap between each band }
  with Canvas do begin
     TempTop := 0;
     TempRect.Left := 0;
     TempRect.Right:= Width;
     for ColorCode := 0 to 255 do begin
        Brush.Color := FBC[ColorCode];
        TempRect.Top  := TempTop;
        TempRect.Bottom := TempTop + TempHeight;
        FillRect(TempRect);
        TempTop := Trunc(TempStepV * ColorCode);
     end;
  end;
end;

procedure Register;
begin
  RegisterComponents('GLAD: Interface', [TGLGradient]);
end;

end.
