unit flt_dlg_editor;

interface

uses
   controls,
   forms,
   flt_dlg,
   DsgnIntf, // for TComponentEditor
   FD_Form  // for TGLFieldSelectionDialog
   ;

type
  TGLFilterDialogEditor = class(TComponentEditor)
     function GetVerbCount : integer ; override ;
     function GetVerb(Index : integer) : string ; override ;
     procedure ExecuteVerb(Index : integer) ; override ;
  end ;

procedure Register;

implementation

{ begin component editor logic }

function TGLFilterDialogEditor.GetVerbCount : integer ;
begin
     Result := 1 ;
end ;

function TGLFilterDialogEditor.GetVerb(Index : integer) : string ;
begin
     case Index of
        0 : Result := '&Edit Fields' ;
     end ;
end ;

procedure TGLFilterDialogEditor.ExecuteVerb(Index : integer) ;
var
  f : TGLFieldSelectionDialog ;
begin
     case Index of

       0: begin
             f := TGLFieldSelectionDialog.Create(nil) ;
             f.ListBox.Items.Assign( (Component as TGLFilterDialog).Fields ) ;
             { In the event that the developer wants to insert fields
               in the list, we must have access to the appropriate dataset.
               Making this a property of the ensuing dialog was the
               cleanest way that I could think of to accomplish this. }
             f.DataSet := (Component as TGLFilterDialog).DataSet ;
             try
                if f.ShowModal = mrOK then
                   with (Component as TGLFilterDialog) do begin
                      Fields.Assign( f.ListBox.Items ) ;
                      Designer.Modified ;
                   end ;
             finally ;
                f.Release ;
             end ;
          end ;
    end ;
end ;

{ end component editor logic }

procedure Register;
begin
  RegisterComponentEditor(TGLFilterDialog, TGLFilterDialogEditor) ;
end;

end.
