unit XLS_editor;

interface

uses
  Classes,
  Dialogs,
  DsgnIntf,
  Windows,
  XLS ;

type
  TGLXLSEditor = class(TComponentEditor)
     // the next three methods are for the pop-up menu
     function GetVerbCount : integer ; override ;
     function GetVerb(i : integer) : string ; override ;
     procedure ExecuteVerb(i : integer) ; override ;
  end ;

  TGLXLSFileNameProperty = class(TStringProperty)
     function GetAttributes : TPropertyAttributes ; override ;
     procedure Edit ; override ;
  end ;

  TGLXLSServerProperty = class(TStringProperty)
     function GetAttributes : TPropertyAttributes ; override ;
     procedure GetValues(Proc: TGetStrProc); override ;
  end ;


procedure Register;

implementation

uses
  FD_Form,   // for TGLFieldSelectionDialog
  Registry ;

//~~~~~ begin property editor logic

function TGLXLSServerProperty.GetAttributes : TPropertyAttributes ;
begin
     Result := inherited GetAttributes + [paValueList,paSortList] ;
end ;

procedure TGLXLSServerProperty.GetValues(Proc: TGetStrProc);
var
   x : integer ;
   t : TRegIniFile ;
   temp : TStringList ;
begin
     temp := TStringList.Create ;
     temp.Sorted := True ;
     t := TRegIniFile.Create('Software\Classes') ;  // key name is irrelevant here
     t.RootKey := HKEY_LOCAL_MACHINE ;
     // NOTE: if you change the RootKey property, you also need
     //       to "refresh" the key by closing and opening.
     t.CloseKey ;
     t.OpenKey('Software\Classes', False) ;
     t.ReadSections(temp) ;
     x := 0 ;
     while Copy(temp[x], 1, 6) <> 'Excel.' do Inc(x) ;
     while Copy(temp[x], 1, 6) = 'Excel.' do begin
        Proc(temp[x]) ;
        Inc(x) ;
     end ;
     t.Free ;
     temp.Free ;
end;

function TGLXLSFileNameProperty.GetAttributes : TPropertyAttributes ;
begin
     Result := inherited GetAttributes + [paDialog] ;
end ;

procedure TGLXLSFileNameProperty.Edit ;
var
   d : TOpenDialog ;
begin
     d := TOpenDialog.Create(nil) ;
     d.DefaultExt := 'XLS' ;
     d.Title := 'Select Spreadsheet File' ;
     d.Filter := 'Spreadsheet files|*.xls' ;
     d.FileName := GetStrValue ;
     try
        if d.Execute then
           SetStrValue(d.FileName) ;
     finally
        d.Free ;
     end ;
end ;

//~~~~~ end property editor logic


//~~~~~ begin component editor logic

function TGLXLSEditor.GetVerbCount : integer ;
begin
     Result := 0 ;
     if ((Component as TGLXLS).DataSet <> nil) then
        if (Component as TGLXLS).FileName <> '' then
           Result := 2
        else
           Result := 1 ;
end ;

function TGLXLSEditor.GetVerb(i : integer) : string ;
begin
     case i of
        0 : Result := 'E&dit Fields' ;
        1 : Result := 'E&xecute' ;
     end ;
end ;

procedure TGLXLSEditor.ExecuteVerb(i : integer) ;
begin
     case i of

        0 : begin
               (Component as TGLXLS).SelectFields ;
               Designer.Modified ;
            end ;

        1 : if (Component as TGLXLS).Execute then
               MessageDlg('Data written to ' + (Component as TGLXLS).FileName,
                          mtInformation, [mbOK], 0) ;
     end ;
end ;

//~~~~~ end component editor logic

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(string),    // data type
                         TGLXLS,                // name of component class
                         'FileName',          // name of property
                         TGLXLSFileNameProperty) ; // property editor class

  RegisterPropertyEditor(TypeInfo(string),    // data type
                         TGLXLS,                // name of component class
                         'Server',            // name of property
                         TGLXLSServerProperty)   ; // property editor class

  RegisterComponentEditor(TGLXLS,               // component class
                          TGLXLSEditor)         // component editor class
end;

end.
