unit ImageIndexEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus,
  DsgnIntf, Buttons ;

type
  TGLImageIndexEditor = class(TIntegerProperty)
     function GetAttributes : TPropertyAttributes ; override ;
     procedure Edit ; override ;
  end ;

  TGLImageIndexEditorForm = class(TForm)
    ListBox: TListBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure ListBoxMeasureItem(Control: TWinControl; Index: Integer;
          var Height: Integer);
    procedure ListBoxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure ListBoxDblClick(Sender: TObject);
  public
    Images : TImageList ;
  end;

procedure Register ;

implementation

{$R *.DFM}

function TGLImageIndexEditor.GetAttributes : TPropertyAttributes ;
begin
    // Detect whether the developer is on a legitimate
    // menu item or one that has not yet been created.
    // Oddly enough, I have found the traditional NIL test to
    // always return True, so we will instead test the Name.
    if (GetComponent(0) as TMenuItem).Name <> '' then
       Result := inherited GetAttributes + [paDialog]
    else
       Result := inherited GetAttributes ;
end ;

procedure TGLImageIndexEditor.Edit ;
var
   f : TGLImageIndexEditorForm ;
   x : integer ;
begin
    with GetComponent(0) as TMenuItem do
       with GetParentMenu do
          if (Images <> nil) and (Images.Count > 0) then begin
             f := TGLImageIndexEditorForm.Create(nil) ;
             try
                f.Images := TImageList(Images) ;
                f.ListBox.Items.BeginUpdate ;
                for x := 0 to Images.Count - 1 do
                   f.ListBox.Items.Add('') ;
                f.ListBox.Items.EndUpdate ;
                f.ListBox.ItemIndex := GetOrdValue ;
                if f.ShowModal = mrOK then
                   SetOrdValue(f.ListBox.ItemIndex) ;
             finally
                f.Release ;
             end ;
          end ;
end ;

procedure TGLImageIndexEditorForm.ListBoxMeasureItem(Control: TWinControl;
  Index: Integer; var Height: Integer);
var
   temp : TBitmap ;
begin
     temp := TBitmap.Create ;
     Images.GetBitmap(Index, temp) ;
     Height := temp.Height + 4 ;
     temp.Free ;
end;

procedure TGLImageIndexEditorForm.ListBoxDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
   temp : TBitmap ;
begin
     with Control as TListBox do begin
        Canvas.FillRect(Rect) ;
        temp := TBitmap.Create ;
        Images.GetBitmap(Index, temp) ;
        Canvas.Draw(Rect.Left + 1, Rect.Top + 1, temp) ;
        temp.Free ;
     end ;
end;

procedure TGLImageIndexEditorForm.ListBoxDblClick(Sender: TObject);
begin
     ModalResult := mrOK ;
end;

procedure Register ;
begin
     RegisterPropertyEditor(TypeInfo(integer),
        TMenuItem,
        'ImageIndex',
        TGLImageIndexEditor)
end ;

end.
