unit GRunBtn_editor ;

interface

uses
  Dialogs, Graphics, GRunBtn, DsgnIntf, Windows ;

type
  TExeFileNameEditor = class(TStringProperty)
    function  GetAttributes : TPropertyAttributes; override;
    procedure Edit ; override;
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
                            const ARect: TRect; ASelected: Boolean); override ;
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas; var AWidth: Integer); override;
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean); override ;
  end;

  TGLRunButtonEditor = class(TComponentEditor)
     function GetVerbCount : integer ; override ;
     function GetVerb(i : integer) : string ; override ;
     procedure ExecuteVerb(i : integer) ; override ;
  end ;

procedure Register;

implementation

uses ShellAPI ;

function TExeFileNameEditor.GetAttributes : TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] ;
end;

procedure TExeFileNameEditor.Edit ;
var
   d : TOpenDialog ;
begin
  d := TOpenDialog.Create(nil) ;
  d.Title := 'Select Executable File' ;
  d.Filter := 'Program files|*.exe' ;
  d.FileName := GetStrValue ;
  if d.Execute then
     SetStrValue(d.FileName) ;
  d.Free ;
end;

procedure TExeFileNameEditor.ListMeasureWidth(const Value: string; ACanvas: TCanvas; var AWidth: Integer);
begin
   AWidth := AWidth + ACanvas.TextHeight( 'M' ) ;
end ;

procedure TExeFileNameEditor.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
          ASelected: Boolean);
begin
   if GetVisualValue <> '' then
      ListDrawValue(GetVisualValue, ACanvas, ARect, True)
   else
      inherited PropDrawValue(ACanvas, ARect, ASelected);
end;

procedure TExeFileNameEditor.ListDrawValue(const Value: string; ACanvas: TCanvas;
          const ARect: TRect; ASelected: Boolean);
const
  ICON_HEIGHT = 14 ;
  ICON_WIDTH  = ICON_HEIGHT ;
var
  h : HICON ;
begin
   h := ExtractIcon(hInstance, PChar((GetComponent(0) as TGLRunButton).ExeFile), 0) ;
   ACanvas.FillRect(ARect) ; 
   DrawIconEx( ACanvas.Handle,
               ARect.Left,
               ARect.Top,
               h,
               ICON_HEIGHT,
               ICON_WIDTH,
               0,
               ACanvas.Brush.Handle,
               DI_NORMAL) ;
   ACanvas.TextOut(ARect.Left + 2 + ICON_WIDTH, ARect.Top + 1, Value) ;
end ;

{ begin component editor logic }

function TGLRunButtonEditor.GetVerbCount : integer ;
begin
     if (Component as TGLRunButton).ExeFile <> '' then
        Result := 1
     else
        Result := 0 ;
end ;

function TGLRunButtonEditor.GetVerb(i : integer) : string ;
begin
     case i of
        0 : Result := 'E&xecute' ;
     end ;
end ;

procedure TGLRunButtonEditor.ExecuteVerb(i : integer) ;
begin
     case i of
        0 : (Component as TGLRunButton).Click ;
     end ;
end ;

{ end component editor logic }

procedure Register;
begin
  RegisterPropertyEditor( TypeInfo(TExeFilename), TGLRunButton,
                          'ExeFile', TExeFileNameEditor );
  RegisterComponentEditor(TGLRunButton, TGLRunButtonEditor) ;
end;

end.
