/*===========================================================================*/
/*                        Copyright (C) 1996-1997 by                         */
/*                                                                           */
/*                    -- TEC-IT Datenverarbeitung GmbH --                    */
/*   -- team for engineering and consulting in information technologies --   */
/*                                                                           */
/*                           All rights reserved.                            */
/*                                                                           */
/*              This is a part of the TEC-IT Standard Software.              */
/*                                                                           */
/*    This source code is only intended as a supplement to the References    */
/*      and related electronic documentation provided with the product.      */
/*                                                                           */
/*     See these sources for detailed information regarding this product     */
/*===========================================================================*/
#ifndef __TECITSTD_H__
#define __TECITSTD_H__

#undef TECIT_DLLSPEC
#ifdef WIN32
#ifdef TECIT_DLLEXPORT
#define TECIT_DLLSPEC _declspec (dllexport)
#endif
#ifdef TECIT_DLLIMPORT
#define TECIT_DLLSPEC _declspec (dllimport)
#endif
#endif	
#ifndef TECIT_DLLSPEC
#define TECIT_DLLSPEC
#endif

#pragma warning (disable:4786) /* debugger info truncated to 255 characters */

/*/////////////////////////////////////////////////////////////////////////////
// TECITStd.h
// Standard header file for TEC-IT projects 
//
// ATTENTION!
// If used with MFC Applications this File must not be included before any 
// MFC-include-file!!
//
/////////////////////////////////////////////////////////////////////////////*/
#include <ctype.h>			
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>			
#include <malloc.h>
#include <memory.h>
#include <math.h>
#include <limits.h>
#include <stdarg.h>			

#ifdef WIN32
#include <tchar.h>
#include <new.h>			
#include <stddef.h>
#include <iostream.h>

#ifndef TECIT_NOSTL
#  ifndef NOMINMAX
#  define NOMINMAX
#  endif
#endif

#ifndef __AFX_H__			/* MFC Application ?							 */
#  pragma warning (disable:4100 4201 4214 4115)
#  include <windows.h>          
#  pragma warning (default:4100 4201 4214 4115)
#endif

/*/////////////////////////////////////////////////////////////////////////////
// STL includes
/////////////////////////////////////////////////////////////////////////////*/
#ifdef __cplusplus
#ifndef TECIT_NOSTL

#include <Vector>			
#include <List>
#include <Stack>
#include <Map>
#include <Set>
#include <Deque>
#include <String>
#include <Algorithm>


/*/////////////////////////////////////////////////////////////////////////////
// TEC-IT standard data types
/////////////////////////////////////////////////////////////////////////////*/
#ifdef _UNICODE
typedef	std::wstring	c_String;	/* STL wide String class				 */
#else
typedef	std::string		c_String;	/* STL String class						 */
#endif


#endif								/* #ifndef TECIT_NOSTL					 */
#endif								/* #ifdef __cplusplus					 */
#endif								/* #ifdef WIN32							 */

/*/////////////////////////////////////////////////////////////////////////////
//
//	Typ-Definitionen
//
/////////////////////////////////////////////////////////////////////////////*/
#ifndef DOUBLE
#  define DOUBLE		double
#endif

#ifndef WIN32
#ifndef INT
#  define INT			int
#endif

#ifndef UINT
#  define UINT			unsigned int
#endif

#ifndef VOID
#  define VOID			void
#endif

#ifndef DWORD
#  define DWORD			unsigned long
#endif

#ifndef ULONG
#  define ULONG			unsigned long
#endif

#ifndef BYTE
#  define BYTE			unsigned char
#endif

#ifndef CHAR
#  define CHAR			char
#endif

#ifndef SHORT
#  define SHORT			short
#endif

#ifndef USHORT
#  define USHORT		unsigned short
#endif

#ifndef LONG
#  define LONG			long
#endif

#ifndef TCHAR
#  define TCHAR			char
#endif

#ifndef BOOL
#  define BOOL			int
#endif

#ifndef WORD
#  define WORD			unsigned short
#endif

#ifndef LPTSTR
#  define LPTSTR		CHAR*
#endif

#ifndef LPCTSTR
#  define LPCTSTR		const CHAR*
#endif

#ifndef LPBOOL
#  define LPBOOL		BOOL*
#endif

#ifndef LPDWORD
#  define LPDWORD		DWORD*
#endif

#ifndef LPBYTE
#  define LPBYTE		BYTE*
#endif

#ifndef LPLONG
#  define LPLONG		LONG*
#endif

#ifndef LPVOID
#  define LPVOID		VOID*
#endif

#ifndef LPCVOID
#  define LPCVOID		const VOID*
#endif

#ifndef DOUBLE
#  define DOUBLE		double
#endif
#endif /* WIN32 */

#ifndef TRUE
#  define TRUE			1
#endif

#ifndef FALSE
#  define FALSE			0
#endif


/*/////////////////////////////////////////////////////////////////////////////
// TEC-IT includes
/////////////////////////////////////////////////////////////////////////////*/
#ifndef TECIT_NOTRACE
#include "TECTrace.h"
#endif

#ifndef TECIT_NOTOOLS
#include "TECTools.h"
#endif

#include "TECErrorCodes.h"



/*/////////////////////////////////////////////////////////////////////////////
// TEC-IT standard macros
/////////////////////////////////////////////////////////////////////////////*/
#define	BYTESIZEOF(v)	(sizeof (v))
#define	CHARSIZEOF(v)	(sizeof (v) / sizeof (v[0]))
#define	ELEMSIZEOF(v)	CHARSIZEOF(v)


/*/////////////////////////////////////////////////////////////////////////////
// TEC-IT memory allocation (SINGLE BYTE / UNICODE enabled)
/////////////////////////////////////////////////////////////////////////////*/
#define	BYTEALLOC(nLen)			(malloc (nLen))
#define	CHARALLOC(nLen)			((LPTSTR)calloc (nLen, sizeof (TCHAR)))
#define BYTEREALLOC(p, nLen)	(realloc (p, nLen))
#define CHARREALLOC(p, nLen)	((LPTSTR)realloc (p, nLen * sizeof (TCHAR)))

/*/////////////////////////////////////////////////////////////////////////////
//  C++ Part
/////////////////////////////////////////////////////////////////////////////*/
#ifdef __cplusplus

#ifndef ASSERT
/*#define ASSERT(expr)		(expr ? 0 : (pTraceObj->TraceVA (TRACEERROR, "ASSERT Failed!: File:%s Line:%d", __FILE__, __LINE__), exit (255)))*/
#if defined (_DBCS) || defined (_UNICODE) || defined (UNICODE)
#  define ASSERT(expr)		(expr ? 0 : (TraceVA (pTraceObj, TRACEERROR, (LPCTSTR)_T("ASSERT Failed!: File:%S Line:%d"), __FILE__, __LINE__), exit (255), 0))
#else
#  define ASSERT(expr)		(expr ? 0 : (TraceVA (pTraceObj, TRACEERROR, (LPCTSTR)_T("ASSERT Failed!: File:%s Line:%d"), __FILE__, __LINE__), exit (255), 0))
#endif
#endif
#ifdef	NDEBUG
#undef	ASSERT
#define ASSERT(expr)
#endif

/*/////////////////////////////////////////////////////////////////////////////
//  C Part
/////////////////////////////////////////////////////////////////////////////*/
#else					/* #ifdef __cplusplus		*/

#ifndef ASSERT
#if defined (_DBCS) || defined (_UNICODE) || defined (UNICODE)
#  define ASSERT(expr)		(expr ? 0 : (TraceVA (pTraceObj, TRACEERROR, (LPCTSTR)_T("ASSERT Failed!: File:%S Line:%d"), __FILE__, __LINE__), exit (255), 0))
#else
#  define ASSERT(expr)		(expr ? 0 : (TraceVA (pTraceObj, TRACEERROR, (LPCTSTR)_T("ASSERT Failed!: File:%s Line:%d"), __FILE__, __LINE__), exit (255), 0))
#endif
#endif
#ifdef	NDEBUG
#undef	ASSERT
#define ASSERT(expr)
#endif

#endif					/* #ifdef __cplusplus		*/

/*/////////////////////////////////////////////////////////////////////////////
// NULL
/////////////////////////////////////////////////////////////////////////////*/
#ifndef NULL
#ifdef __cplusplus
#define NULL    0
#else
#define NULL    ((VOID *)0)
#endif
#endif

#ifndef WIN32
#ifndef _T
#define _T(t)	t
#endif
#define __max(a,b)  (((a) > (b)) ? (a) : (b))
#define __min(a,b)  (((a) < (b)) ? (a) : (b))
#define iswalpha(_c)	( isalpha(_c) )
#define iswupper(_c)	( isupper(_c) )
#define iswlower(_c)	( islower(_c) )
#define iswdigit(_c)	( isdigit(_c) )
#define iswxdigit(_c)	( isxdigit(_c))
#define iswspace(_c)	( isspace(_c) )
#define iswpunct(_c)	( ispunct(_c) )
#define iswalnum(_c)	( isalnum(_c) )
#define iswprint(_c)	( isprint(_c) )
#define iswgraph(_c)	( isgraph(_c) )
#define iswcntrl(_c)	( iscntrl(_c) )
#define iswascii(_c)	( isascii(_c) )
#define towupper(_c)	( toupper(_c) )
#define towlower(_c)	( tolower(_c) )
#endif

/*/////////////////////////////////////////////////////////////////////////////////////
//
//	timeb - Datentyp
//
/////////////////////////////////////////////////////////////////////////////////////*/
#ifdef WIN32
#define	TIMEB	struct	_timeb
#else
#define TIMEB	struct	timeb
#endif

#pragma warning(default:4018 4114 4146 4244 4245 4663 4664 4665 4100      4510 4511 4512 4610 4702      4237 4201 4211 4238) // TEC-IT
#endif					/* #ifndef __TECITSTD_H__	*/

