/*===========================================================================*/
/*                        Copyright (C) 1996-1997 by                         */
/*                                                                           */
/*                    -- TEC-IT Datenverarbeitung GmbH --                    */
/*   -- team for engineering and consulting in information technologies --   */
/*                                                                           */
/*                           All rights reserved.                            */
/*                                                                           */
/*              This is a part of the TEC-IT Standard Software.              */
/*                                                                           */
/*    This source code is only intended as a supplement to the References    */
/*      and related electronic documentation provided with the product.      */
/*                                                                           */
/*     See these sources for detailed information regarding this product     */
/*===========================================================================*/
#ifndef __TECERRORCODES_H__
#define __TECERRORCODES_H__

#undef TECIT_DLLSPEC
#ifdef WIN32
#ifdef TECIT_DLLEXPORT
#define TECIT_DLLSPEC _declspec (dllexport)
#endif
#ifdef TECIT_DLLIMPORT
#define TECIT_DLLSPEC _declspec (dllimport)
#endif
#endif	
#ifndef TECIT_DLLSPEC
#define TECIT_DLLSPEC
#endif

#ifdef __cplusplus
	extern "C"
	{
#endif

/*
//
//	See WinError.h
//
//  Values are 32 bit values layed out as follows (according to HRESULT)
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +-+-+-+-+-+-+-------------------+-------------------------------+
//  |S|R|C|N|r|E|    Facility       |               Code            |
//  +-+-+-+-+-+-+-------------------+-------------------------------+
//
//      S - Severity - indicates success/fail
//
//          0 - Success
//          1 - Fail 
//
//      R - reserved portion of the facility code, corresponds to NTs
//              second severity bit.
//
//      C - reserved portion of the facility code, corresponds to NTs
//              C field. 
//		  - indicates a TEC-IT statuscode if set
//
//      N - reserved portion of the facility code. Used to indicate a
//              mapped NT status value.
//
//      r - reserved portion of the facility code. Reserved for internal
//              use. Used to indicate HRESULT values that are not status
//              values, but are instead message ids for display strings.
//
//		E - indicates an C errno value if set
//
//      Facility - is the facility code
//
//      Code - is the facilitys status code
*/

#define TEC_MSK_TEC					0x40000000
#define TEC_MSK_ENO					0x04000000
#define TEC_MSK_FAC					0x03FF0000
#define TEC_MSK_CODE				0x8000FFFF
#define TEC_MSK_SEV					0x80000000


#define	TEC_CODE(nCode)				(nCode & TEC_MSK_CODE)
#define	TEC_FAC(nCode)				((nCode & TEC_MSK_FAC) >> 16)
#define	TEC_ToFAC(nCode)			((nCode << 16) & TEC_MSK_FAC)
#define	TEC_SEV(nCode)				(nCode & TEC_MSK_SEV)

/*/////////////////////////////////////////////////////////////////////////////
// convert TEC-IT error number to error-number useful in VB
/////////////////////////////////////////////////////////////////////////////*/
#define TEC2ActX(nErr)			(nErr & ~TEC_MSK_SEV)

#define CTL_E_TECITERROR(nErr)	CUSTOM_CTL_SCODE(1000 + TEC2ActX(nErr))


/*/////////////////////////////////////////////////////////////////////////////
// generate TEC-IT error number
/////////////////////////////////////////////////////////////////////////////*/
#define	TEC(nFac,nCode)				(TEC_ToFAC (nFac) | nCode | TEC_MSK_TEC)

/*/////////////////////////////////////////////////////////////////////////////
// convert WIN32 error to TEC-IT error number
/////////////////////////////////////////////////////////////////////////////*/
#ifdef WIN32
#ifdef __AFXWIN_H__						// AFX already included -> HRESULT is known
#  define TEC_HRESULT_FROM_WIN32		HRESULT_FROM_WIN32
#else									// AFX not included -> #define HRESULT as LONG
#  define TEC_HRESULT_FROM_WIN32(x)		((ULONG)((x ? ((ULONG) ((((ULONG)x) & 0x0000FFFF) | (FACILITY_WIN32 << 16) | 0x80000000)) : 0 )))
#endif

#  define W32toTEC(nCode)				TEC_HRESULT_FROM_WIN32 (nCode)
#endif

/*/////////////////////////////////////////////////////////////////////////////
// convert C-runtime errno to TEC-IT error number
/////////////////////////////////////////////////////////////////////////////*/
#define ENOtoTEC(nFac,nCode)		(TEC_ToFAC (nFac) | nCode | TEC_MSK_TEC | TEC_MSK_ENO)

/*/////////////////////////////////////////////////////////////////////////////
// facility codes (TEC-IT standard)
/////////////////////////////////////////////////////////////////////////////*/
#define FacGeneric						0x00000000	/* Generic (or unknown facility)			*/
#define FacTools						0x00000001	/* Tools									*/								
#define FacGadget						0x00000002	/* Gadget									*/
#define FacManager						0x00000003	/* Gadget Manager							*/
#define FacSymbolScanner				0x00000004	/* Symbol Scanner							*/
#define FacExpression					0x00000005	/* Expression Evaluation					*/
#define FacQueue						0x00000006	/* Queue Manager							*/
#define FacVarCont						0x00000007	/* Variable container						*/
#define FacLabel						0x00000008	/* Label									*/
#define FacLauncher						0x00000009	/* NT Launcher service						*/
#define FacUPS							0x0000000A	/* Coordinator (Universal Problem Solver)	*/
#define FacTimer						0x0000000B	/* Timers									*/
#define	FacSystem						0x0000000C	/* Operating System (use with errno)		*/
#define	FacTCK							0x0000000D	/* TEC-IT Converter Kernel					*/
#define	FacCOM							0x0000000E	/* TECStdCom								*/
#define	FacPool							0x0000000F	/* TECStdPool								*/
#define	FacESQL							0x00000010	/* ESQL										*/
#define	FacRegTab						0x00000011	/* Registry Table Def's						*/
#define	FacBinTree						0x00000012	/* Binary Tree								*/
#define	FacLinkList						0x00000013	/* Linked List								*/
#define	FacDLinkList					0x00000014	/* Double Linked List						*/
#define	FacError						0x00000015	/* Error Message system						*/
#define	FacPSPipe						0x00000016	/* Printserver Pipe							*/
#define	FacOPCClient					0x00000017	/* OPC Client								*/
#define	FacOPCKernel					0x00000018	/* OPC Kernel								*/
#define	FacOPCCacheThread				0x00000019	/* OPC Cache Thread							*/
#define	FacOPCClientThread				0x0000001A	/* OPC Client Thread						*/
#define	FacOPCDeviceThread				0x0000001B	/* OPC Device Thread						*/
#define	FacOPCVendorIF					0x0000001C	/* OPC Device Thread						*/
#define	FacTECIO						0x0000001D	/* TEC-IT Input/OutputDll					*/
#define	FacPrintServer					0x0000001E	/* PrintServer								*/
#define	FacVirtualPort					0x0000001F	/* Virtual Port KTVP						*/
#define	FacBarCode						0x00000020	/* Barcode Generator						*/
#define FacDBConnection					0x00000021	/* Database Connection						*/
#define FacMiniC						0x00000022	/* MiniC Interpreter						*/


/*/////////////////////////////////////////////////////////////////////////////
// error codes (TEC-IT standard)
/////////////////////////////////////////////////////////////////////////////*/
#define	ErrOk							0x00000000	/* NO ERROR									*/
#define ErrNotSupported					0x80000001	/* feature not supported					*/
#define ErrInternalError				0x80000002	/* internal error							*/
#define ErrOutOfMemory					0x80000003	/* out of memory							*/
#define ErrOutOfRange					0x80000004	/* out of range								*/
#define ErrEOF							0x80000005	/* premature EOF							*/
#define ErrCloseBracketRequired			0x80000006	/* ']' required								*/
#define ErrCloseParentheseRequired		0x80000007	/* ')' required								*/
#define ErrOpenParentheseRequired		0x80000008	/* '(' required								*/
#define ErrIdentifierRequired			0x80000009	/* identifier required						*/
#define ErrCommaRequired				0x8000000A	/* ',' required								*/
#define ErrOperandRequired				0x8000000B	/* operand required							*/
#define ErrIllegalNumber				0x8000000C	/* illegal number							*/
#define ErrIllegalChar					0x8000000D	/* illegal character						*/
#define ErrIllegalString				0x8000000E	/* illegal string							*/
#define ErrSyntaxError					0x8000000F	/* syntax error								*/
#define ErrNotDefined					0x80000010	/* Function/Variable not defined			*/
#define ErrAlreadyDefined				0x80000011	/* Function/Variable already defined		*/
#define ErrDivisionByZero				0x80000012	/* division by zero							*/
#define ErrIncompatibleTypes			0x80000013	/* incompatible argument types				*/
#define ErrKeywordMismatch				0x80000014	/* wrong or missing keyword					*/
#define ErrParameterMismatch			0x80000015	/* parameter mismatch						*/
#define ErrFunctionRequired				0x80000016	/* Left of '(' is not a function			*/
#define ErrWrongNumberOfParameters		0x80000017	/* wrong number of parameters				*/
#define ErrParameterMissing				0x80000018	/* missing function parameter 				*/
#define	ErrIllegalType					0x80000019	/* illegal type								*/
#define	ErrOperationAborted				0x8000001A	/* operation aborted						*/
#define	ErrAlreadyStarted				0x8000001B	/* Already started							*/
#define	ErrAlreadyStopped				0x8000001C	/* Already stopped							*/
#define	ErrNotInstalled					0x8000001D	/* Not installed							*/
#define	ErrAlreadyInstalled				0x8000001E	/* Already installed						*/
#define	ErrNotProcessed					0x8000001F	/* Not processed							*/
#define	ErrUnknown						0x80000020	/* Unknown or unspecified error				*/
#define	ErrLeftOpMustBeLValue			0x80000021	/* Left operand must be l-value				*/
#define	ErrNoMatch						0x80000022	/* No match									*/
#define	ErrNotStarted					0x80000023	/* Not Started								*/
#define	ErrNotStopped					0x80000024	/* Not Stopped								*/
#define	ErrIdentTooLong					0x80000025	/* Identifier too long						*/
#define	ErrOverflow						0x80000026	/* Overflow									*/
#define	ErrUnderflow					0x80000027	/* Underflow								*/
#define	ErrNotFound						0x80000028	/* Not Found								*/
#define	ErrWrongCharacter				0x80000029	/* Wrong Character							*/
#define	ErrWrongNumberOfCharacters		0x8000002A	/* Wrong Number of Characters				*/
#define ErrSemicolonRequired			0x8000002B  /* ';' required								*/
#define ErrVersion						0x8000002C  /* Wrong Version							*/
#define ErrOnlyOneMiniCBlockAllowed		0x8000002D  /* Only one MiniC block allowed				*/
#define ErrNotLicensed					0x8000002E	/* No License								*/
#define ErrOutOfLicenses				0x8000002F	/* Not enough Licenses						*/
#define ErrDllFunctionNotLoaded			0x80000030	/* Dll or function not loaded				*/
#define ErrCodeTooLong					0x80000031	/* given code too long        				*/
#define ErrNoSeparator					0x80000032	/* missing separator line					*/
#define ErrNoForm						0x80000033	/* missing Form definition					*/
#define ErrNoPrinter					0x80000034	/* missing Printer definition				*/
#define ErrNoHeader						0x80000035	/* missing header information               */
#define ErrNoTypeDef					0x80000036	/* missing type definition					*/

#define	ERRCODE	DWORD

/*/////////////////////////////////////////////////////////////////////////////
//	Initialize Error Message System
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
ERRCODE			TECErrorInitialize
(
);

/*/////////////////////////////////////////////////////////////////////////////
//	Deinitialize Error Message System
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
ERRCODE			TECErrorDeinitialize
(
);

/*/////////////////////////////////////////////////////////////////////////////
//	Add new Error-Code and Error-String
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
ERRCODE			TECErrorAddEcode
(
UINT			nCode,
LPCTSTR			pText
);

/*/////////////////////////////////////////////////////////////////////////////
//	Add new Facility-Code and Facility-String
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
ERRCODE			TECErrorAddFac
(
UINT			nFac,
LPCTSTR			pText
);

/*/////////////////////////////////////////////////////////////////////////////
//	Return facility string
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
LPCTSTR			WINAPI	GetFacDescFromError 
(
ERRCODE			eErrCode			/* IN : error code						 */
);

/*/////////////////////////////////////////////////////////////////////////////
//	Return error string
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
LPCTSTR			WINAPI	GetErrDescFromError 
(
ERRCODE			eErrCode			/* IN : error code							 */
);

/*/////////////////////////////////////////////////////////////////////////////
//	Return formatted error description
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
LPCTSTR			FormatError 
(
 ERRCODE	eErrCode,			/* IN : error code							 */
 LPCTSTR	psFormat,			/* IN : Format string						 */
 ...
);

#ifdef __cplusplus
	}
#endif

#endif