/*===========================================================================*/
/*                        Copyright (C) 1996-1999 by                         */
/*                                                                           */
/*                    -- TEC-IT Datenverarbeitung GmbH --                    */
/*   -- team for engineering and consulting in information technologies --   */
/*                                                                           */
/*                           All rights reserved.                            */
/*                                                                           */
/*              This is a part of the TEC-IT Standard Software.              */
/*                                                                           */
/*    This source code is only intended as a supplement to the References    */
/*      and related electronic documentation provided with the product.      */
/*                                                                           */
/*     See these sources for detailed information regarding this product     */
/*===========================================================================*/
#ifndef __TECBARCODE_H__
#define __TECBARCODE_H__

#undef TECIT_DLLSPEC
#ifdef WIN32
#ifdef TECIT_DLLEXPORT
#define TECIT_DLLSPEC _declspec (dllexport)
#endif
#ifdef TECIT_DLLIMPORT
#define TECIT_DLLSPEC _declspec (dllimport)
#endif
#endif	
#ifndef TECIT_DLLSPEC
#define TECIT_DLLSPEC
#endif

#ifdef __cplusplus
	extern "C"
	{
#endif

/*/////////////////////////////////////////////////////////////////////////////
//
//	We are using 8 Byte Alignment
//
/////////////////////////////////////////////////////////////////////////////*/
#pragma pack (push, 8)

/*/////////////////////////////////////////////////////////////////////////////
//
//	General Information
//
/////////////////////////////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////////////////////////////
//
//   If any of the BCxxxx functions below returns an error code not equal to 
//	 zero than DO NOT call subsequent BCxxxx functions except of BCDeInit ().
//
//   An error code <> 0 indicates an error condition at subsequent calls 
//	 (except to BCDeInit) may fail and produce unexpected results.
//
/////////////////////////////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////////////////////////////
//
//	 BCLicenseMe:This function licenses the DLL. It's not required to call this
//				function each time you use the DLL in your program (although
//				it's allowed). 
//				Licensing must be performed per computer system at least once.
//				(e.g. in the setup program of your application)
//
//   BCInit:	This function initalizes the Barcode-Info structure.
//				It must be called before any other BCxxxx function.
//
//   BCCheck:	This function checks if the data charcters are valid for the
//				selected barcode type. If invalid data was encountered it 
//				returns an error-code <> 0.
//				It must be called before BCCalcCD().
//
//   BCCalcCD:	This function computes the check digit(s) for the given data.
//				It must be called before BCCreate().
//
//   BCCreate:	This function prepares the barcode-info structure to be drawn 
//				with BCDraw. It returns ErrOk if the everything is
//				ok. If not it returns an error-code which specifies the
//				error in more detail.
//
//   BCDraw:	This function draws a barcode into the given device-
//				context. No spacial mapping is performed. 
// 
//				* if nBarWidth is equal to BC_USEDEFAULT the standard  
//				bar/space ratios are used. See TECBCEnum.h
//
//				* if sRatio is not NULL and is not equal to an empty string  
//				then it is analyzed and the print ratios are adjusted as specified
//				in sRatio. See TECBCEnum.h
//
//				* if sModWidth is not NULL and is not equal to an empty string  
//				then it is converted to a numeber which specifies the modul width
//				[1/1000 mm]. See TECBCEnum.h
//
//	 BCGetReatioString 
//				This function return a string containing intoamtion about the
//				expected ratio input.
//
//	 BCGetMaxLenOfData 
//				This function returns a long, representing the maximum allowed number
//				of chars for the pIn (RawData)
//
//
//   BCDeInit:	This function de-initalizes the Barcode-Info structure and
//				frees allocated memory. It must be called as last function.
//
/////////////////////////////////////////////////////////////////////////////*/
#define	TECIT_NO_HELPSTRINGS
#include "TECBCEnum.h"
#undef	TECIT_NO_HELPSTRINGS


/*/////////////////////////////////////////////////////////////////////////////
//
//	Constants
//
/////////////////////////////////////////////////////////////////////////////*/
#ifndef __PDF417_SUPPORTED
#  define __PDF417_SUPPORTED
#endif
#define	BC_USEDEFAULT	-1

/*/////////////////////////////////////////////////////////////////////////////
//
//	Barcode-Info Structure
//
/////////////////////////////////////////////////////////////////////////////*/
typedef struct tag_BarCode
{
	LPCTSTR		pIn;			/* Ptr to raw data							 */
	INT			nIn;			/* Length of data in characters				 */


	e_BarCType	eBarCType;		/* Type of Barcode							 */
	e_CDMethod	eCDMethod;		/* Check Digit Method						 */
	BOOL		bAutoCorrect;	/* TRUE if barcode data should be corrected  */
								/* in case of wrong format					 */
								/* i.e.: leading 0 if odd # of chars (2OF5IL)*/
	COLORREF	ColorBarC;		/* Color of Barcode							 */

	DOUBLE		dRotation;		/* counter-clockwise rotation				 */
								/* supported values: 0, 90, 180, 270 degrees */
	BOOL		bReadable;		/* Print human readable interpretation		 */
	BOOL		bAbove;			/* Print readable interpretation above code	 */
	LOGFONT		LogFont;		/* BarCode Font								 */
	COLORREF	ColorFont;		/* Color of Font							 */

	INT			nGuardWidth;	/* width of guard line [1/1000 mm]			 */
	LPCTSTR		sModWidth;		/* Module width [1/1000 mm]					 */
	LPCTSTR		sFormat;		/* Barcode Format							 */
	LPCTSTR		sRatio;			/* Barcode Ratio String						 */

	INT			nModWidth;		/* module width in [1/1000 mm]				 */
	INT			nBarWidth;		/* number of width values in dBar[]			 */
	INT			nSpaceWidth;	/* number of width values in dSpace[]		 */
	DOUBLE		dBar[26];		/*											 */
	DOUBLE		dSpace[26];		/*											 */
	
	INT			nCheckDigits;	/* Number of Check-Digits in array			 */
	INT			nCheck[10];		/* Check digits								 */

	LPTSTR		szIntData;		/* Internal Barcode Data					 */
								/* after format is applied to input-data	 */
	INT			nIntData;		/* Length of internal data					 */
								/* after format is applied to input-data	 */
#pragma warning (disable : 4201)
	union
	{
		LPTSTR	szPattern;		/* Space where barcode-pattern is stored	 */
		LPWORD	pWPattern;		/* used for PDF417							 */
	};
#pragma warning (default : 4201)

	INT			nPattern;		/* Length of szData	[CHARACTERS]			 */
	BOOL		bTranslateEsc;	/* TRUE if escape sequences should be        */
								/* translated                                */
#ifdef __PDF417_SUPPORTED
	INT			nPatLen;		/* actual length of pattern in units         */
								/* (only used by PDF)                        */
	INT			nRows;			/* number of rows                            */
	INT			nColumns;		/* number of columns                         */
	INT			nErrorLevel;	/* level of error correction                 */
	INT			nRowHeight;		/* height of rows                            */
#endif
} t_BarCode;

		
/*/////////////////////////////////////////////////////////////////////////////
//
//	Functions
//
/////////////////////////////////////////////////////////////////////////////*/


/*/////////////////////////////////////////////////////////////////////////////
//	License the DLL
//	
//	Returns: ErrOk if ok 
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
ERRCODE		_stdcall		BCLicenseMe
(
LPCTSTR						lpszLicensee,	/* IN : Licensee name			 */
DWORD						dwKindOfLicense,/* IN : kind of license			 */
DWORD						dwNoOfLicenses,	/* IN : number of licenses		 */
LPCTSTR						lpszKey,		/* IN : License Key				 */
DWORD						dwProductID		/* IN : Product ID				 */
);

/*/////////////////////////////////////////////////////////////////////////////
//	Initialize Barcode-Structure
//	
//	Returns: ErrOk if ok 
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
ERRCODE		_stdcall		BCInit
(
t_BarCode*	const	pBarCode			/* IN : Ptr To Barcode-Definition	 */
);

/*/////////////////////////////////////////////////////////////////////////////
//	DeInitialize Barcode-Structure
//	
//	Returns: ErrOk if ok 
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
ERRCODE		_stdcall		BCDeInit
(
t_BarCode*	const	pBarCode			/* IN : Ptr To Barcode-Definition	 */
);

/*/////////////////////////////////////////////////////////////////////////////
//	Returns ratio-String
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
LPCTSTR		_stdcall		BCGetRatioString
(
t_BarCode*	const			pBarCode	/* IN : Ptr To Barcode-Definition	 */
);

/*/////////////////////////////////////////////////////////////////////////////
//	Returns the exact number of chars that have to be in pIn (RawData)
//  Returns 0 if there is no specified length or BarcodeType not known
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
LONG		_stdcall		BCGetMaxLenOfData
(
t_BarCode*	const			pBarCode	/* IN : Ptr To Barcode-Definition	 */
);

/*/////////////////////////////////////////////////////////////////////////////
//	Check barcode input data for validity
//	
//	Returns: ErrOk if ok 
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
ERRCODE		_stdcall		BCCheck
(
t_BarCode*	const			pBarCode	/* IN : Ptr To Barcode-Definition	 */
);

/*/////////////////////////////////////////////////////////////////////////////
//	Calculate Check Digit
//	
//	Returns: ErrOk if ok 
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
ERRCODE		_stdcall		BCCalcCD
(
t_BarCode*	const			pBarCode	/* IN : Ptr To Barcode-Definition	 */
);

/*/////////////////////////////////////////////////////////////////////////////
//	Create barcode-string from data according to the specified barcode-struct
//	
//	Returns: ErrOk if ok 
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
ERRCODE		_stdcall		BCCreate
(
t_BarCode*	const			pBarCode	/* IN : Ptr To Barcode-Definition	 */
);


/*/////////////////////////////////////////////////////////////////////////////
//	Draw barcode into Device Context
//	
//	Returns: ErrOk if ok 
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
ERRCODE		_stdcall		BCDraw
(
t_BarCode*	const			pBarCode,	/* IN : Ptr To Barcode-Definition	 */
HDC							hDC,		/* IN : Device Context Handle		 */
RECT*						pRect		/* IN : Bounding Rectangle			 */
);

/*/////////////////////////////////////////////////////////////////////////////
//	Returns List of implemented Barcodes (in Text)
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
LPCTSTR*	_stdcall		BCGetBCList
(
);

/*/////////////////////////////////////////////////////////////////////////////
//	Returns List of implemented Check Digits (in Text), dependent on type
/////////////////////////////////////////////////////////////////////////////*/	
TECIT_DLLSPEC	
e_CDMethod*	_stdcall		BCGetCDListByType
(
e_BarCType	eBCType
);

/*/////////////////////////////////////////////////////////////////////////////
//	returns name of check digit method
/////////////////////////////////////////////////////////////////////////////*/	
TECIT_DLLSPEC	
LPCTSTR	_stdcall		BCGetNameFromEnum
(
e_CDMethod	eCDMethod
);

/*/////////////////////////////////////////////////////////////////////////////
//	Returns List of implemented Check Digits (in Text)
/////////////////////////////////////////////////////////////////////////////*/	
TECIT_DLLSPEC	
LPCTSTR*	_stdcall		BCGetCDList
(
);

/*/////////////////////////////////////////////////////////////////////////////
//	copies barcode to clipboard
//	
//	Returns: ErrOk if ok 
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
ERRCODE	_stdcall	BCCopyToClipboard
(
t_BarCode*	const	pBarCode,			/* IN : Ptr To Barcode-Definition	                    */
HDC					hDC,				/* IN : device context to copy from  (default: NULL)    */
LONG				nWidth,				/* IN : width of barcode to copy                        */
LONG				nHeight,			/* IN : height of barcode to copy                       */
BOOL				fTransparent,		/* IN : Barcode transparent or not                      */
COLORREF			crBkCol,			/* IN : Background color (only if fTransparent == FALSE)*/
LPCTSTR				szFileName			/* IN : name of enh. metafile, that the barcode should  */
										/*      be copied to (NULL for clipboard only)          */
);

/*/////////////////////////////////////////////////////////////////////////////
//	computes default error level
//	
//	Returns: errorlevel
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
INT		_stdcall	ComputeDefaultErrLevel
(
t_BarCode*	const	pBarCode			/* IN : Ptr To Barcode-Definition	 */
);

/*/////////////////////////////////////////////////////////////////////////////
//	computes the module width in 
//	
//	Returns: module width
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
DOUBLE	_stdcall	BCGetModuleWidth
(
t_BarCode*	const	pBarCode,			/* IN : Ptr To Barcode-Definition	                        */
LPRECT				pRect,				/* IN : bounding rectangle (NULL --> min. modwidth)         */
e_unit				eUnit,				/* IN : unit of measure                                     */
HDC					hDC					/* IN : device context                                      */
);

/*/////////////////////////////////////////////////////////////////////////////
//	computes the barcode width
//	
//	Returns: barcode width
/////////////////////////////////////////////////////////////////////////////*/
TECIT_DLLSPEC	
DOUBLE	_stdcall	BCGetBarcodeWidth
(
t_BarCode*	const	pBarCode,			/* IN : Ptr To Barcode-Definition	                            */
LPRECT				pRect,				/* IN : bounding rectangle		 (NULL --> min. modwidth)       */
e_unit				eUnit,				/* IN : unit of measure                                         */
HDC					hDC					/* IN : device context                                          */
);

/*///////////////////////////////////////////////////////////////////////////*/

#pragma pack (pop)

#ifdef __cplusplus
	}
#endif

#endif