
/*////////////////////////////////////////////////////////////////////////////////////////////
//
//	Helpstring macro - expands to ["My String"] if compiling .ODL file
//
////////////////////////////////////////////////////////////////////////////////////////////*/
#ifndef TECIT_NO_HELPSTRINGS
#  define	TECIT_HS(s)	[helpstring(s)]
#else
#  undef	TECIT_HS
#  define	TECIT_HS(s)
#endif

/*////////////////////////////////////////////////////////////////////////////////////////////
//
//	Standard print ratios
//
//	1B, 2B, 3B, 4B    .....   bar widths 
//	1S, 2S, 3S, 4S    .....   space widths 
//
////////////////////////////////////////////////////////////////////////////////////////////*/
/* eBC_None,		 Print ratios								 	standard check digit		*/

/* eBC_Code11,		 1:2.24:3.48:1:2.24	(1B:2B:3B:1S:2S)		 	eCDNone						*/
/* eBC_2OF5,		 1:3:4.5:1:3		(1B:2B:3B:1S:2S)			eCDNone						*/
/* eBC_2OF5IL,		 1:3:1:3			(1B:2B:1S:2S)			 	eCDNone						*/
/* eBC_2OF5IATA,	 1:3:1				(1B:2B:1S)				 	eCDNone						*/
/* eBC_2OF5M,		 1:3:4.5:1:3		(1B:2B:3B:1S:2S)		 	eCDNone						*/
/* eBC_2OF5DL,		 1:3:1:3			(1B:2B:1S:2S)			 	eCDNone						*/
/* eBC_2OF5IND,		 1:3:1				(1B:2B:1S)				 	eCDNone						*/
/* eBC_3OF9,		 1:3:1:3			(1B:2B:1S:2S)			 	eCDNone						*/
/* eBC_3OF9A,		 1:3:1:3			(1B:2B:1S:2S)			 	eCDNone						*/
/* eBC_EAN8,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDEAN8						*/
/* eBC_EAN8P2,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDEAN8						*/
/* eBC_EAN8P5,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDEAN8						*/
/* eBC_EAN13,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDEAN13					*/
/* eBC_EAN13P2,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDEAN13					*/
/* eBC_EAN13P5,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDEAN13					*/
/* eBC_EAN128,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDCode128					*/
/* eBC_UPC12,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDUPCA						*/
/* eBC_CodaBar2,	 1:3:1:3			(1B:2B:1S:2S)			 	eCDNone						*/
/* eBC_CodaBar18,	 -------									 	----						*/
/* eBC_Code128,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDCode128					*/
/* eBC_Code128A,	 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDCode128					*/
/* eBC_Code128B,	 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDCode128					*/
/* eBC_Code128C,	 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDCode128					*/
/* eBC_DPLeit,		 1:3:1:3			(1B:2B:1S:2S)			 	eCDDPLeit					*/
/* eBC_DPIdent,		 1:3:1:3			(1B:2B:1S:2S)			 	eCDDPIdent					*/
/* eBC_Code16K,		 -------									 	----						*/
/* eBC_49,			 -------									 	----						*/
/* eBC_9OF3,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCD2Mod47					*/
/* eBC_UPC25,		 -------									 	----						*/
/* eBC_UPCD1,		 -------									 	----						*/
/* eBC_UPCD2,		 -------									 	----						*/
/* eBC_UPCD3,		 -------									 	----						*/
/* eBC_UPCD4,		 -------									 	----						*/
/* eBC_UPCD5,		 -------									 	----						*/
/* eBC_UPCSCC,		 -------									 	----						*/
/* eBC_UCC128,		 -------									 	----						*/
/* eBC_UPCA,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDUPCA						*/
/* eBC_UPCAP2,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDUPCA						*/
/* eBC_UPCAP5,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDUPCA						*/
/* eBC_UPCE,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDUPCE						*/
/* eBC_UPCEP2,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDUPCE						*/
/* eBC_UPCEP5,		 1:2:3:4:1:2:3:4	(1B:2B:3B:4B:1S:2S:3S:4S)	eCDUPCE						*/
/* eBC_PostNet5,	 1:1				(1B:1S)  				 	eCDPostNet					*/
/* eBC_PostNet6,	 1:1				(1B:1S)  				 	eCDPostNet					*/
/* eBC_PostNet8,	 1:1				(1B:1S)  				 	eCDNone						*/
/* eBC_PostNet10,	 1:1				(1B:1S)  				 	eCDPostNet					*/
/* eBC_PostNet11,	 1:1				(1B:1S)  				 	eCDPostNet					*/
/* eBC_PostNet12,	 1:1				(1B:1S)  				 	eCDPostNet					*/
/* eBC_Plessey,		 1:2:1:2			(1B:2B:1S:2S)			 	eCDPlessey					*/
/* eBC_MSI,			 1:2:1:2			(1B:2B:1S:2S)			 	eCDMSI1						*/
/* eBC_POSTCODE,	 -------									 	----						*/
/* eBC_FIM,			 -------									 	----						*/
/* eBC_LOGMARS,		 -------									 	----						*/
/* eBC_DUN,			 -------									 	----						*/
/* eBC_PHILIPS,		 -------									 	----						*/
/* eBC_DOTCODEA,	 -------									 	----						*/
/* eBC_GP,			 -------									 	----						*/
/* eBC_PDF417,		 1:2:3:4:5:6:7:8:	(1B:2B:3B:4B:5B:6B:7B:8B:
					 1:2:3:4:5:6		 1S:2S:3S:4S:5S:6S)		 	eCDNone						*/
/* eBC_PDF417Trunc,	 1:2:3:4:5:6:7:8:	(1B:2B:3B:4B:5B:6B:7B:8B:
					 1:2:3:4:5:6		 1S:2S:3S:4S:5S:6S)		 	eCDNone						*/
/* eBC_MAXICODE,	 -------									 	----						*/
/* eBC_QRCode,		 -------									 	----						*/

/*/////////////////////////////////////////////////////////////////////////////
//
//	Supported Barcodes
//
/////////////////////////////////////////////////////////////////////////////*/
typedef	enum	tag_BarCType
{
	TECIT_HS("None")					eBC_None,					/* No valid barcode type					 */
	TECIT_HS("Code 11")					eBC_Code11,					/* Code 11									 */
	TECIT_HS("Code 2OF5 Standard")		eBC_2OF5,					/* Code 2 of 5 (standard)					 */
	TECIT_HS("Code 2OF5 Interleaved")	eBC_2OF5IL,					/* Interleaved 2 of 5 (standard)			 */
	TECIT_HS("Code 2OF5 IATA")			eBC_2OF5IATA,				/* Code 2 of 5 IATA							 */
	TECIT_HS("Code 2OF5 Matrix")		eBC_2OF5M,					/* Code 2 of 5 Matrix					     */
	TECIT_HS("Code 2OF5 DataLogic")		eBC_2OF5DL,					/* Code 2 of 5 Data Logic					 */
	TECIT_HS("Code 2OF5 Industry")		eBC_2OF5IND,				/* Code 2 of 5 Industrial					 */
	TECIT_HS("Code 39")					eBC_3OF9,					/* Code 3 of 9 (Code 39)					 */
	TECIT_HS("Code 39 Full ASCII")		eBC_3OF9A,					/* Code 3 of 9 (Code 39) Ascii 				 */
	TECIT_HS("EAN8")					eBC_EAN8,					/* EAN8										 */
	TECIT_HS("EAN8P2")					eBC_EAN8P2,					/* EAN8	 - 2 digits add on					 */
	TECIT_HS("EAN8P5")					eBC_EAN8P5,					/* EAN8	 - 5 digits add on					 */
	TECIT_HS("EAN13")					eBC_EAN13,					/* EAN13									 */
	TECIT_HS("EAN13P2")					eBC_EAN13P2,				/* EAN13 - 2 digits add on					 */
	TECIT_HS("EAN13P5")					eBC_EAN13P5,				/* EAN13 - 5 digits add on					 */
	TECIT_HS("EAN128")					eBC_EAN128,					/* EAN128									 */
	TECIT_HS("UPC12")					eBC_UPC12,					/* UPC 12 Digits							 */
	TECIT_HS("CodaBar 2 Widths")		eBC_CodaBar2,				/* CodaBar (2 width)						 */
	TECIT_HS("CodaBar 18 Widths")		eBC_CodaBar18,				/* unsupported CodaBar (18 widths)			 */
	TECIT_HS("Code128")					eBC_Code128,				/* Code128									 */
	TECIT_HS("DP Leitcode")				eBC_DPLeit,					/* Deutsche Post Leitcode					 */
	TECIT_HS("DP Identcode")			eBC_DPIdent,				/* Deutsche Post Identcode					 */
	TECIT_HS("Code 16K")				eBC_Code16K,				/* unsupported								 */
	TECIT_HS("Code 49")					eBC_49,						/* unsupported								 */
	TECIT_HS("Code 93")					eBC_9OF3,					/* Code 93									 */
	TECIT_HS("UPC25")					eBC_UPC25,					/* identical to eBC_UPCA					 */
	TECIT_HS("UPCD1")					eBC_UPCD1,					/* unsupported								 */
	TECIT_HS("UPCD2")					eBC_UPCD2,					/* unsupported								 */
	TECIT_HS("UPCD3")					eBC_UPCD3,					/* unsupported								 */
	TECIT_HS("UPCD4")					eBC_UPCD4,					/* unsupported								 */
	TECIT_HS("UPCD5")					eBC_UPCD5,					/* unsupported								 */
	TECIT_HS("UPCSCC")					eBC_UPCSCC,					/* unsupported								 */
	TECIT_HS("UCC128")					eBC_UCC128,					/* same as EAN128							 */
	TECIT_HS("UPCA")					eBC_UPCA,					/* UPC A									 */
	TECIT_HS("UPCAP2")					eBC_UPCAP2,					/* UPC A - 2 digit add on					 */
	TECIT_HS("UPCAP5")					eBC_UPCAP5,					/* UPC A - 5 digit add on					 */
	TECIT_HS("UPCE")					eBC_UPCE,					/* UPC E 									 */
	TECIT_HS("UPCEP2")					eBC_UPCEP2,					/* UPC E - 2 digit add on					 */
	TECIT_HS("UPCEP5")					eBC_UPCEP5,					/* UPC E - 5 digit add on					 */
	TECIT_HS("PostNet5")				eBC_PostNet5,				/* PostNet ZIP (5 digits)					 */
	TECIT_HS("PostNet6")				eBC_PostNet6,				/* PostNet ZIP (5 digits + check digit)		 */
	TECIT_HS("PostNet8")				eBC_PostNet8,				/* PostNet ZIP (8 digits)					 */
	TECIT_HS("PostNet10")				eBC_PostNet10,				/* PostNet ZIP+4 (5 digits + 4 digits + CD)  */
	TECIT_HS("PostNet11")				eBC_PostNet11,				/* PostNet DPBC  (5 d. + 4 d. + 2 d.)		 */
	TECIT_HS("PostNet12")				eBC_PostNet12,				/* PostNet DPBC  (5 d. + 4 d. + 2 d. + CD)   */
	TECIT_HS("Plessey")					eBC_Plessey,				/* Plessey Code								 */
	TECIT_HS("MSI")						eBC_MSI,					/* MSI Code									 */
	TECIT_HS("POSTCODE")				eBC_POSTCODE,				/* unsupported								 */
	TECIT_HS("FIM")						eBC_FIM,					/* unsupported								 */
	TECIT_HS("LOGMARS")					eBC_LOGMARS,				/* unsupported								 */
	TECIT_HS("DUN")						eBC_DUN,					/* unsupported								 */
	TECIT_HS("PHILIPS")					eBC_PHILIPS,				/* unsupported								 */
	TECIT_HS("DOTCODEA")				eBC_DOTCODEA,				/* unsupported								 */
	TECIT_HS("General Parcel")			eBC_GP,						/* unsupported								 */
	TECIT_HS("PDF417")					eBC_PDF417,					/* PDF417   								 */
	TECIT_HS("PDF417 Truncated")		eBC_PDF417Trunc,			/* PDF417 Truncated							 */
	TECIT_HS("MAXICODE")				eBC_MAXICODE,				/* unsupported								 */
	TECIT_HS("QR-Code")					eBC_QRCode,					/* unsupported								 */
	TECIT_HS("Code128A")				eBC_Code128A,				/* Code128 Subset A							 */
	TECIT_HS("Code128B")				eBC_Code128B,				/* Code128 Subset B							 */
	TECIT_HS("Code128C")				eBC_Code128C,				/* Code128 Subset C							 */
} e_BarCType;


///////////////////////////////////////////////////////////////////////////////
//
//	Supported Check Digit Methods
//
///////////////////////////////////////////////////////////////////////////////
typedef	enum	tag_CDMethod
{
	TECIT_HS("None")					eCDNone			= 0,		/* No check digit calculation is performed		*/
	TECIT_HS("Standard")				eCDStandard		,			/* standard check digit method will be applied	*/
	TECIT_HS("Modulo 10")				eCDMod10		,			/*												*/
	TECIT_HS("Modulo 43")				eCDMod43		,			/*												*/
	TECIT_HS("Modulo 47 (2 digits)")	eCD2Mod47		,			/*												*/
	TECIT_HS("DP Leitcode")				eCDDPLeit		,			/*												*/
	TECIT_HS("DP Identcode")			eCDDPIdent		,			/*												*/
	TECIT_HS("Code11 (1 digit)")		eCD1Code11		,			/*												*/
	TECIT_HS("Code11 (2 digits)")		eCD2Code11		,			/*												*/
	TECIT_HS("Postnet")					eCDPostnet		,			/*												*/
	TECIT_HS("MSI (1 digit)")			eCDMSI1			,			/*												*/
	TECIT_HS("MSI (2 digits)")			eCDMSI2			,			/*												*/
	TECIT_HS("Plessey")					eCDPlessey		,			/*												*/
	TECIT_HS("EAN 8")					eCDEAN8			,			/*												*/
	TECIT_HS("EAN 13")					eCDEAN13		,			/*												*/
	TECIT_HS("UPC A")					eCDUPCA			,			/*												*/
	TECIT_HS("UPC E")					eCDUPCE			,			/*												*/
	TECIT_HS("EAN 128")					eCDEAN128		,			/*												*/
	TECIT_HS("Code 128")				eCDCode128		,			/*												*/
} e_CDMethod;		

///////////////////////////////////////////////////////////////////////////////
//
//	measure units
//
///////////////////////////////////////////////////////////////////////////////
typedef enum tag_unit
{
	TECIT_HS("Pixel")					eun_pixel		= 0,
	TECIT_HS("mm")						eun_mm			,
} e_unit;

