// BarcTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TBarcode_exe.h"
#include "BarcTest.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBarcTestDlg dialog
/////////////////////////////////////////////////////////////////////////////
CBarcTestDlg::CBarcTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBarcTestDlg::IDD, pParent)
{
ERRCODE	eCode = ErrOk;

	//{{AFX_DATA_INIT(CBarcTestDlg)
	m_bAbove = FALSE;
	m_bPrint = FALSE;
	m_strFormat = _T("");
	m_strModul = _T("");
	m_strRatio = _T("");
	m_nGuardWidth = 0;
	m_strRatioHint = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	eCode = BCInit (&m_barCode);
}

/////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////
CBarcTestDlg::~CBarcTestDlg()
{
	BCDeInit (&m_barCode);
}

/////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBarcTestDlg)
	DDX_Control(pDX, IDC_CB_CD, m_cbCD);
	DDX_Control(pDX, IDC_CMB_ORIENT, m_cbOrient);
	DDX_Control(pDX, IDC_CB_TYP, m_cbTyp);
	DDX_Control(pDX, IDC_ED_CODE, m_edCode);
	DDX_Control(pDX, IDC_BARCODE, m_backGround);
	DDX_Check(pDX, IDC_CHK_ABOVE, m_bAbove);
	DDX_Check(pDX, IDC_CHK_PRINT, m_bPrint);
	DDX_Text(pDX, IDC_EDIT_FORMAT, m_strFormat);
	DDX_Text(pDX, IDC_EDIT_MODUL, m_strModul);
	DDX_Text(pDX, IDC_EDIT_RATIO, m_strRatio);
	DDX_Text(pDX, IDC_EDIT_GUARD, m_nGuardWidth);
	DDV_MinMaxInt(pDX, m_nGuardWidth, 0, 10000);
	DDX_Text(pDX, IDC_EDIT_RATIOHINT, m_strRatioHint);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////
BEGIN_MESSAGE_MAP(CBarcTestDlg, CDialog)
	//{{AFX_MSG_MAP(CBarcTestDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_EN_KILLFOCUS(IDC_ED_CODE, OnKillfocus_EdCode)
	ON_CBN_SELCHANGE(IDC_CB_TYP, OnSelchange_CbTyp)
	ON_BN_CLICKED(IDC_BTN_FONT, OnBtnFont)
	ON_BN_CLICKED(IDC_BTN_BARCOLOR, OnBtnBarcolor)
	ON_BN_CLICKED(IDC_CHK_ABOVE, OnChkAbove)
	ON_BN_CLICKED(IDC_CHK_PRINT, OnChkPrint)
	ON_CBN_SELCHANGE(IDC_CMB_ORIENT, OnSelchangeCbOrient)
	ON_EN_CHANGE(IDC_EDIT_FORMAT, OnChangeEditFormat)
	ON_EN_CHANGE(IDC_EDIT_GUARD, OnChangeEditGuard)
	ON_EN_CHANGE(IDC_EDIT_MODUL, OnChangeEditModul)
	ON_EN_CHANGE(IDC_EDIT_RATIO, OnChangeEditRatio)
	ON_CBN_SELCHANGE(IDC_CB_CD, OnSelchangeCbCd)
	ON_BN_CLICKED(IDC_BTN_HELP, OnBtnHelp)
	ON_BN_CLICKED(IDC_BTN_LICENSE, OnBtnLicense)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBarcTestDlg message handlers

////////////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////////////
BOOL CBarcTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	for (INT i = 0; BCGetBCList()[i]; i++)
		m_cbTyp.AddString (BCGetBCList()[i]);

	for (i = 0; BCGetCDList()[i]; i++)
		m_cbCD.AddString (BCGetCDList()[i]);

	m_cbTyp.SetCurSel (1);
	m_cbOrient.SetCurSel (0);
	m_cbCD.SetCurSel (1);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);

	}
	else
	{
		CDialog::OnPaint();
		DrawBC();
	}
}

////////////////////////////////////////////////////////////////////////////////////////
// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
////////////////////////////////////////////////////////////////////////////////////////
HCURSOR CBarcTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
VOID			CBarcTestDlg::DrawBC(VOID)
{
RECT			WinRect;
ERRCODE			eCode;
CDC*			dc;
INT				nIndex;
static	CString	str;

	eCode = ErrOk;
	dc = GetDC();
	m_backGround.GetWindowRect ( &WinRect );
	ScreenToClient( &WinRect );


	m_edCode.GetWindowText (str);
	m_barCode.pIn		= (LPCTSTR)str;
	m_barCode.nIn		= str.GetLength();

	nIndex = m_cbTyp.GetCurSel();
	m_barCode.eBarCType		= (nIndex < 0) ? (e_BarCType)0 : (e_BarCType) nIndex;
	if (m_cbCD.GetCurSel() >= 0)
		m_barCode.eCDMethod = (e_CDMethod)m_cbCD.GetCurSel();
	else
		m_barCode.eCDMethod = eCDStandard;
	m_barCode.nModWidth		= BC_USEDEFAULT;
	m_barCode.nBarWidth		= BC_USEDEFAULT;
	m_barCode.nSpaceWidth	= BC_USEDEFAULT;
	m_barCode.nGuardWidth	= 0;
	m_barCode.bAbove		= FALSE;
	m_barCode.bReadable		= TRUE;

	m_barCode.sModWidth		= m_strModul;
	m_barCode.sFormat		= m_strFormat;
	m_barCode.sRatio		= m_strRatio;
	m_barCode.nGuardWidth	= m_nGuardWidth;
	m_barCode.bReadable		= m_bPrint;
	m_barCode.bAbove		= m_bAbove;

	switch (m_cbOrient.GetCurSel ())
	{
	default	: m_barCode.dRotation = 0.0		; break;
	case 1	: m_barCode.dRotation = 90.0	; break;
	case 2	: m_barCode.dRotation = 180.0	; break;
	case 3	: m_barCode.dRotation = 270.0	; break;
	}

	// in case of PDF417 select default values (no efect for other bar code types)
	m_barCode.nRows			= 
	m_barCode.nColumns		= 
	m_barCode.nErrorLevel	= 
	m_barCode.nRowHeight	=  BC_USEDEFAULT;

	eCode = (eCode == ErrOk) ? BCCheck	(&m_barCode) : eCode;
	eCode = (eCode == ErrOk) ? BCCalcCD	(&m_barCode) : eCode;
	eCode = (eCode == ErrOk) ? BCCreate	(&m_barCode) : eCode;
	dc->FillSolidRect (&WinRect, RGB (127, 127, 127));
	eCode = (eCode == ErrOk) ? BCDraw	(&m_barCode, dc->GetSafeHdc(), &WinRect) : eCode;
}

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnKillfocus_EdCode() 
{
	Invalidate();
}


////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnSelchange_CbTyp() 
{
	if (m_cbTyp.GetCurSel() >= 0)
		m_barCode.eBarCType	= (e_BarCType)m_cbTyp.GetCurSel();
	m_strRatioHint = BCGetRatioString (&m_barCode);
	UpdateData (FALSE);

	Invalidate();
}

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnBtnFont() 
{
CFontDialog		cFont (&m_barCode.LogFont);

	if (cFont.DoModal () == IDOK)
	{
		m_barCode.LogFont	= *cFont.m_cf.lpLogFont;
		m_barCode.ColorFont = cFont.m_cf.rgbColors;
		Invalidate();
	}
}

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnBtnBarcolor() 
{
	CColorDialog	cColor;

	if (cColor.DoModal () == IDOK)
	{
		m_barCode.ColorBarC = cColor.GetColor ();
		Invalidate();
	}
}

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnChkAbove() 
{
	UpdateData (TRUE);
	Invalidate();
}

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnChkPrint() 
{
	UpdateData (TRUE);
	Invalidate();
}


////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnSelchangeCbOrient() 
{
	UpdateData (TRUE);
	Invalidate();
}

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnChangeEditFormat() 
{
	UpdateData (TRUE);
	Invalidate();
}

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnChangeEditGuard() 
{
	UpdateData (TRUE);
	Invalidate();
}

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnChangeEditModul() 
{
	UpdateData (TRUE);
	Invalidate();
}

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnChangeEditRatio() 
{
	UpdateData (TRUE);
	Invalidate();
}

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnSelchangeCbCd() 
{
	Invalidate();
}


////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnBtnHelp() 
{
	AfxGetApp ()->WinHelp(0, HELP_FINDER);
}

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnBtnLicense() 
{
#ifdef _VER_1_4_
	BCLicenseMe ("Licensee - as specified", 1, "12345678");
#else
	BCLicenseMe ("Licensee - as specified", 2, 1, "12345678", 4);
#endif
}

////////////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////////////
void CBarcTestDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}
