unit tbl_mgr ;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBTables ;

type
  TGLTableManager = class(TComponent)
  private
    FAutoScan : boolean ;
    FTables : TStringList ;
    procedure GetOpenTables ; virtual ;
  public
    constructor Create(AOwner : TComponent) ; override ;
    destructor Destroy ; override ;
    function Open(const a : array of TTable) : boolean ;
    procedure Close(const a : array of TTable) ;
    procedure ShowInfo ; virtual ;
  published
    property AutoScan : boolean read FAutoScan write FAutoScan default False ;
  end;

procedure Register;

implementation

uses TblForm2 ;

constructor TGLTableManager.Create(AOwner : TComponent) ;
begin
     inherited ;
     FTables := TStringList.Create ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLTableManager (1.0) - Copyright  1998 Greg Lief',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

destructor TGLTableManager.Destroy ;
begin
     FTables.Free ;
     inherited ;
end ;

function TGLTableManager.Open(const a : array of TTable) : boolean ;
var
   x : integer ;
begin
     try
        for x := 0 to High(a) do begin
           a[x].Open ;
           FTables.AddObject(a[x].Name, a[x]) ;
        end ;
        Result := True ;
     except
        MessageDlg('Could not open ' + a[x].TableName, mtError, [mbOK], 0) ;
        Result := False ;
     end ;
end ;

procedure TGLTableManager.Close(const a : array of TTable) ;
var
   x : integer ;
   y : integer ;
begin
     for x := 0 to High(a) do begin
        a[x].Close ;
        y := 0 ;
        while (y < FTables.Count) and (a[x] <> FTables.Objects[y]) do
           Inc(y) ;
        if y < FTables.Count then
           FTables.Delete(y) ;
     end ;
end ;

procedure TGLTableManager.ShowInfo ;
var
   f : TTableForm ;
begin
     f := TTableForm.Create(nil) ;
     try
        if FAutoScan then
           GetOpenTables ;
        if FTables.Count = 0 then
           MessageDlg('No tables open', mtInformation, [mbOK], 0)
        else begin
           f.Tables.Items.Assign( FTables ) ;
           f.Tables.ItemIndex := 0 ;
           f.TablesClick(f.Tables) ;
           f.ShowModal ;
        end ;   
     finally
        f.Release ;
     end ;
end ;

procedure TGLTableManager.GetOpenTables ;
var
   x, y : integer ;
begin
     FTables.Clear ;
     { 1: find open tables on this form }
     with Owner as TForm do
        for x := 0 to ComponentCount - 1 do
           if (Components[x] is TTable) and TTable(Components[x]).Active then
              FTables.AddObject(Components[x].Name, Components[x]) ;

     { 2: find open tables in any datamodules owned by Application object }
     for x := 0 to Application.ComponentCount - 1 do
        if (Application.Components[x] is TDataModule) then
           with Application.Components[x] as TDataModule do
              for y := 0 to ComponentCount - 1 do
                 if (Components[y] is TTable) and TTable(Components[y]).Active then
                    FTables.AddObject(Components[y].Name, Components[y]) ;

     { 3 : find open tables on any other forms owned by Application object }
     for x := 0 to Application.ComponentCount - 1 do
        if (Application.Components[x] is TForm) and (Application.Components[x] <> Owner) then
           with Application.Components[x] as TForm do
              for y := 0 to ComponentCount - 1 do
                 if (Components[y] is TTable) and TTable(Components[y]).Active then
                    FTables.AddObject(Components[y].Name, Components[y]) ;
end ;

procedure Register;
begin
  RegisterComponents('Greg Lief', [TGLTableManager]);
end;

end.
