unit ImgGrid;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids;

type
  { forward class declaration to satisfy compiler }
  TGLDBImageGrid = class ;

  TTestDataCondition = procedure (Grid : TGLDBImageGrid ;
                       Column : TColumn ;
                       State: TGridDrawState ;
                       var ImageNumber : integer) of object ;

  TGLDBImageGrid = class(TDBGrid)
  private
     FBitmap : TBitmap ;
     FTestDataCondition : TTestDataCondition ;
     FImageList : TImageList ;   { storage location }
  protected
     procedure Notification(AComponent: TComponent;
               Operation: TOperation); override ;
     procedure DrawColumnCell(const Rect: TRect;
               DataCol: Integer; Column: TColumn;
               State: TGridDrawState); override ;
  public
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
  published
     property ImageList : TImageList read FImageList write FImageList ;
     property TestDataCondition : TTestDataCondition
              read FTestDataCondition write FTestDataCondition ;
  end;

procedure Register;

implementation

constructor TGLDBImageGrid.Create(AOwner : TComponent) ;
begin
     inherited ;   { calls TDBGrid.Create }
     FBitmap := TBitmap.Create ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLDBImageGrid 1.0 - Copyright  1998 Greg Lief',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

destructor TGLDBImageGrid.Destroy ;
begin
     FBitmap.Free ;
     inherited ;
end ;

procedure TGLDBImageGrid.Notification(AComponent: TComponent;
          Operation: TOperation);
begin
     if (Operation = opRemove) and (AComponent = FImageList) then
        FImageList := nil ;
end ;


procedure TGLDBImageGrid.DrawColumnCell(const Rect: TRect;
  DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
   ImageNumber : integer ;
begin
     ImageNumber := -1 ;
     if Assigned(FTestDataCondition) and Assigned(FImageList) then
        FTestDataCondition(self, Column, State, ImageNumber) ;
     Canvas.FillRect(Rect) ;
     if (ImageNumber <> -1) and (ImageNumber <= FImageList.Count) then begin
        FImageList.GetBitmap(ImageNumber, FBitmap) ;
        Canvas.Draw(Rect.Left + 1, Rect.Top + 1, FBitmap) ;
        Canvas.TextOut(Rect.Left + FBitmap.Width + 5, Rect.Top,
                       Column.Field.AsString) ;
     end
     else
        Canvas.TextOut(Rect.Left + 1, Rect.Top + 1,
                       Column.Field.AsString) ;
end;

procedure Register;
begin
  RegisterComponents('GLAD: DBGrids', [TGLDBImageGrid]);
end;

end.
