unit hintgrid ;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids;

type
  TGLDBHintGrid = class ;

  TNewColumnEvent = procedure (Grid : TGLDBHintGrid; Col, Row : integer) of object ;

  TGLDBHintGrid = class(TDBGrid)
  private
     FOldMouseCol : integer ;
     FOnNewColumn : TNewColumnEvent ;
     FHints : TStringList ;
     procedure SetHints(s : TStringList) ;
  protected
     procedure WMMouseMove(var Message : TWMMouse) ; message WM_MOUSEMOVE;
     procedure Loaded ; override ;
  public
     MouseRow : integer ;
     MouseCol : integer ;
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
  published
     property Hints : TStringList read FHints write SetHints ;
     property OnNewColumn : TNewColumnEvent read FOnNewColumn write FOnNewColumn ;
  end;

procedure Register;

implementation

constructor TGLDBHintGrid.Create(AOwner : TComponent) ;
begin
     inherited ;
     FHints := TStringList.Create ;
     FOldMouseCol := -1 ;
     ShowHint := True ;  { that's the whole point of this grid, isn't it? }
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLDBHintGrid (1.0) - Copyright  1998 Greg Lief',
                   mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

procedure TGLDBHintGrid.Loaded ;
var
   x : integer ;
begin
     inherited ;
     if (not (csDesigning in ComponentState)) then
        if Columns.State = csCustomized then begin
           for x := 0 to Columns.Count - 1 do
              if x > FHints.Count - 1 then
                 FHints.Add(Columns[x].FieldName)
              else if FHints.Strings[x] = '' then
                 FHints.Strings[x] := Columns[x].FieldName ;
        end
        else if (DataSource <> nil) and (DataSource.DataSet <> nil) then
           with DataSource.DataSet do
              for x := 0 to FieldCount - 1 do
                 if x > FHints.Count - 1 then
                    FHints.Add(Fields[x].FieldName)
                 else if FHints.Strings[x] = '' then
                    FHints.Strings[x] := Fields[x].FieldName ;
end ;

destructor TGLDBHintGrid.Destroy ;
begin
     FHints.Free ;
     inherited ;
end ;

procedure TGLDBHintGrid.SetHints(s : TStringList) ;
begin
     FHints.Assign(s) ;
end ;     

procedure TGLDBHintGrid.WMMouseMove(var Message : TWMMouse) ;
var
   t : TGridCoord ;
   r : TMessage ;
begin
     t := MouseCoord(Message.XPos, Message.YPos) ;
     MouseCol := t.x ;
     MouseRow := t.y ;
     if (MouseCol <> FOldMouseCol) and (MouseCol <> -1) then begin
        FOldMouseCol := MouseCol ;
        if dgIndicator in Options then Dec(MouseCol) ;
        if MouseCol > -1 then begin
           if Assigned(FOnNewColumn) then
              FOnNewColumn(self, MouseCol, MouseRow) ;
           if FHints.Strings[MouseCol] <> '' then
              Hint := FHints.Strings[MouseCol] ;
           Application.HintMouseMessage(TControl(Owner), r) ;
           TWMMouse(r).XPos := Message.XPos ;
           TWMMouse(r).YPos := Message.YPos ;
           Application.HintMouseMessage(self, r) ;
        end ;   
     end ;
     inherited ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: DBGrids', [TGLDBHintGrid]);
end;

end.
