unit glhinted;

interface

uses
  {$IFDEF WIN32}
  Windows, 
  {$ELSE}
  WinTypes, WinProcs,
  {$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons,
  DsgnIntf ;

type
  TGLHintEditor = class(TStringProperty)
     function GetAttributes : TPropertyAttributes ; override ;
     procedure Edit ; override ;
  end ;

  TGLHintEditorForm = class(TForm)
    mHint: TMemo;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure Register ;

implementation

{$R *.DFM}


function TGLHintEditor.GetAttributes : TPropertyAttributes ;
begin
     Result := inherited GetAttributes + [paDialog] ;
end ;

procedure TGLHintEditor.Edit ;
begin
     with TGLHintEditorForm.Create(nil) do
        try
           Caption := 'Editing ' + (GetComponent(0) as TComponent).Name + '.Hint' ;
           mHint.Text := GetStrValue ;
           if ShowModal = mrOK then
              SetStrValue( mHint.Text ) ;
        finally
           Release ;
        end ;
end ;

procedure Register ;
begin
     RegisterPropertyEditor(TypeInfo(string),
                            TControl,
                            'Hint',
                            TGLHintEditor) ;
end ;

end.
