unit glcalced;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes, WinProcs,
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TGLCalcEdit = class(TCustomMemo)
  private
    FCanvas : TCanvas ;
    FOldBlinkTime : cardinal ;
    FOldOnActivate : TNotifyEvent ;
    FOldOnDeactivate : TNotifyEvent ;
//    FWidth : integer ;
    procedure LeaveApp(Sender: TObject) ;
    procedure ReturnToApp(Sender: TObject) ;
    function GetValue : extended ;
    procedure SetValue(e : extended) ;
  protected
    procedure CreateWnd ; override ;
    procedure KeyDown(var Key: Word; Shift: TShiftState) ; override ;
    procedure KeyPress(var Key: Char) ; override ;
    procedure DoEnter ; override ;
    procedure DoExit ; override ;
  public
    constructor Create(AOwner : TComponent) ; override ;
    destructor Destroy ; override ;
  published
    property Align;
    property Color;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property HideSelection;
    property OEMConvert;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    {$IFDEF WIN32}
    property OnStartDrag;
    {$ENDIF}
    property Value : extended read GetValue write SetValue ;
//    property Width : integer read FWidth write FWidth ;
  end;

procedure Register;

implementation

const
   SLOW_BLINK_TIME = 50000 ;

constructor TGLCalcEdit.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     Alignment := taRightJustify ;
     AutoSelect := False ;
     WantReturns := False ;
     WordWrap := False ;
     FCanvas := TCanvas.Create ;
     FCanvas.Handle := GetDC( (Owner as TForm).Handle )  ;
end ;

destructor TGLCalcEdit.Destroy ;
begin
     { reset Application.OnDeactivate and OnActivate events
       if we bypassed the OnExit event (e.g., by closing app via system menu }
     if Assigned(FOldOnDeactivate) then begin
        Application.OnDeactivate := FOldOnDeactivate ;
        Application.OnActivate   := FOldOnActivate ;
     end ;
     { reset blink time if we bypassed the OnExit event }
     if GetCaretBlinkTime = SLOW_BLINK_TIME then
        SetCaretBlinkTime( FOldBlinkTime ) ;
     { release resources for canvas device context }
     ReleaseDC( 0, FCanvas.Handle ) ;
     { free canvas object }
     FCanvas.Free ;
     inherited Destroy ;
end ;

procedure TGLCalcEdit.CreateWnd ;
begin
     inherited CreateWnd ;
     Height := 21 ;
     Value := 0 ;
     SelStart := Length(Text) ;
end ;

function TGLCalcEdit.GetValue : extended ;
begin
     try
        Result := StrToFloat(Text) ;
     except
        Result := 0 ;
     end ;
end ;

procedure TGLCalcEdit.SetValue(e : extended) ;
begin
     try
        Text := FloatToStr(e) ;
     except
     end ;
end ;

procedure TGLCalcEdit.KeyPress(var Key: Char);
begin
     if ( ( (Key = DecimalSeparator) or (Key = #46) ) and
             ( (Pos(DecimalSeparator, Text) = 0) and (Pos(#46, Text) = 0) ) ) or
          ( (Ord(Key) = 48) and (Text <> '0') ) or
          ( (Ord(Key) > 48) and (Ord(Key) < 58) ) then begin
        { clear leading zero UNLESS they entered a decimal separator }
        if (Text = '0') and (not (Key in [#46, DecimalSeparator]) ) then
           Text := ''
        else begin
           { convert period (ASCII 46) to current decimal separator }
           if Key = #46 then
              Key := DecimalSeparator ;
           FCanvas.Font.Assign( Font ) ;
           { test whether display is already full }
           if FCanvas.TextWidth(Text + Key) >= ClientWidth then
              { if the entire text is selected, this keypress will replace its contents }
              if SelLength = Length(Text) then
                 Text := ''
              else  { discard the keypress }
                 Key := #0 ;
        end
     end
     else
        Key := #0 ;
end;

procedure TGLCalcEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
     case Key of
        VK_LEFT,
        VK_RIGHT,
        VK_UP,
        VK_DOWN,
        VK_HOME,
        VK_END : Key := 0 ;

        VK_TAB : if ssCtrl in Shift then
                    Key := 0 ;

        8 : if Text <> '' then
               begin
                  // also lop off trailing decimal point if necessary
                  if ( Text[ Length(Text) - 1 ] = DecimalSeparator ) or
                     ( Text[ Length(Text) - 1 ] = #46 ) then
                     Text := Copy(Text, 1, Length(Text) - 2)
                  else
                     Text := Copy(Text, 1, Length(Text) - 1) ;
                  Key := 0 ;
                  if Text = '' then
                     Text := '0' ;
                  SelStart := Length(Text) ;
               end ;
     end ;
end;

procedure TGLCalcEdit.DoEnter ;
begin
     FOldBlinkTime := GetCaretBlinkTime ;
     SetCaretBlinkTime( SLOW_BLINK_TIME ) ;
     SelStart := Length(Text) ;
     FOldOnActivate   := Application.OnActivate ;
     FOldOnDeactivate := Application.OnDeactivate ;
     Application.OnActivate   := ReturnToApp ;
     Application.OnDeactivate := LeaveApp ;
{     HideCaret( Handle ) ;  why doesn't this work?!   }
     inherited DoEnter ;
end ;

procedure TGLCalcEdit.DoExit ;
var
   x : integer ;
begin
     { lop off any trailing zeros }
     x := Length( Text ) ;
     while Text[x] = '0' do
        Dec(x) ;
     Text := Copy(Text, 1, x) ;
     if Text = '' then
        Text := '0' ;

     { reset cursor blink }
     SetCaretBlinkTime( FOldBlinkTime ) ;
     { reset Application.OnDeactivate }
     Application.OnDeactivate := FOldOnDeactivate ;
     FOldOnDeactivate := nil ;
     Application.OnActivate := FOldOnActivate ;
     FOldOnActivate := nil ;
{     ShowCaret( Handle ) ;  why doesn't this work?!   }
     inherited DoExit ;
end ;

procedure TGLCalcEdit.LeaveApp(Sender: TObject) ;
begin
     SetCaretBlinkTime(FOldBlinkTime) ;
end ;

procedure TGLCalcEdit.ReturnToApp(Sender: TObject) ;
begin
     SetCaretBlinkTime( SLOW_BLINK_TIME ) ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Interface', [TGLCalcEdit]);
end;

end.
