unit fontlist ;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Printers ;

type
  TFontType = (ftScreen, ftPrinter, ftBoth) ;

  TGLFontListBox = class(TCustomListBox)
  private
     FFontType : TFontType ;
     function GetSelectedFont : string ;
     procedure SetSelectedFont(s : string) ;
     procedure SetFontType(t : TFontType) ;
  protected
     procedure CreateWnd ; override ;
     procedure DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState); override ;
     procedure MeasureItem(Index : Integer; var Height: Integer); override ;
  public
     constructor Create(AOwner : TComponent) ; override ;
  published
     property FontType : TFontType read FFontType write SetFontType default ftScreen ;
     property SelectedFont : string read GetSelectedFont write SetSelectedFont ;
     property Color;
     property Ctl3D;
     property DragCursor;
     property DragMode;
     property Enabled;
     property Font ;
     property ParentColor;
     property ParentCtl3D;
     property ParentFont;
     property ParentShowHint;
     property ShowHint;
     property TabOrder;
     property TabStop;
     property Visible;
     property OnClick;
     property OnDblClick;
     property OnDragDrop;
     property OnDragOver;
     property OnEndDrag;
     property OnEnter;
     property OnExit;
     property OnKeyDown;
     property OnKeyPress;
     property OnKeyUp;
     property OnMouseDown;
     property OnMouseMove;
     property OnMouseUp;
     {$IFDEF WIN32}
     property OnStartDrag;
     {$ENDIF}
  end;

procedure Register;

implementation

constructor TGLFontListBox.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     Style := lbOwnerDrawVariable ;
     Sorted := True ;
end ;

procedure TGLFontListBox.CreateWnd ;
begin
     inherited CreateWnd ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLFontListBox (1.0) - Copyright  1998 Greg Lief',
                   mtInformation, [mbOK], 0) ;
{$ENDIF}
     SetFontType(FFontType) ;
end ;

procedure TGLFontListBox.SetFontType(t : TFontType) ;
var
   x : integer ;
   OldCursor : TCursor ;
   temp : TStringList ;
begin
     FFontType := t ;
     Items.Clear ;
     case t of
        ftScreen  : for x := 0 to Screen.Fonts.Count - 1 do
   	               if Printer.Fonts.IndexOf(Screen.Fonts[x]) = -1 then
	                  Items.Add(Screen.Fonts[x]) ;
        ftPrinter : for x := 0 to Printer.Fonts.Count - 1 do
                       if Screen.Fonts.IndexOf(Printer.Fonts[x]) = -1 then
		          Items.Add(Printer.Fonts[x]) ;
        ftBoth    : begin
                       OldCursor := Screen.Cursor ;
                       Screen.Cursor := crHourGlass ;
                       temp := TStringList.Create ;
                       temp.Sorted := True ;
                       temp.Duplicates := dupIgnore ;
                       temp.AddStrings(Printer.Fonts) ;
                       temp.AddStrings(Screen.Fonts) ;
                       Items.Assign(temp) ;
                       temp.Free ;
                       Screen.Cursor := OldCursor ;
                    end ;
     end ;
end ;

function TGLFontListBox.GetSelectedFont : string ;
begin
     if ItemIndex <> -1 then
        Result := Items[ItemIndex]
     else
        Result := '<none>'   ;
end ;

procedure TGLFontListBox.SetSelectedFont(s : string) ;
var
   x : integer ;
begin
     x := Items.IndexOf(s) ;
     if x <> -1 then
        ItemIndex := x ;
end ;

procedure TGLFontListBox.DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
     Canvas.Font.Name := Items[Index] ;
     Canvas.FillRect(Rect) ;
     Canvas.TextOut(Rect.Left + 1, Rect.Top, Items[Index]) ;
end;

procedure TGLFontListBox.MeasureItem(Index: Integer; var Height: Integer);
begin
     Canvas.Font.Name := Items[Index] ;
     Height := Canvas.TextHeight(Items[Index]) ;
end;

procedure Register;
begin
  RegisterComponents('GLAD: Interface', [TGLFontListBox]);
end;

end.
