unit AppSet ;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls ;

type
  TGLAppSettings = class(TComponent)
  private
     FFlashing : boolean ;
     FFlashInterval : integer ;
     FOldTitle : string ;
     FShowTimeWhenMinimized : boolean ;
     FTimer : TTimer ;
     {$IFDEF WIN32}
     function GetHintShortPause : integer ;
     procedure SetHintShortPause(i : integer) ;
     function GetHintHidePause : integer ;
     procedure SetHintHidePause(i : integer) ;
     function GetShowMainForm : boolean ;
     procedure SetShowMainForm(b : boolean) ;
     {$ENDIF}

     {$IFDEF VER100}  { Delphi 3 only }
     function GetUpdateFormatSettings : boolean ;
     procedure SetUpdateFormatSettings(b : boolean) ;
     function GetUpdateMetricSettings : boolean ;
     procedure SetUpdateMetricSettings(b : boolean) ;
     {$ENDIF}

     function GetHintColor : TColor ;
     function GetHintPause : integer ;
     function GetShowHint  : boolean ;
     function GetInterval : integer ;
     procedure SetFlashing(b : boolean) ;
     procedure SetFlashInterval(i : integer) ;
     procedure SetHintColor(c : TColor) ;
     procedure SetHintPause(i : integer) ;
     procedure SetShowHint(b : boolean) ;
     procedure SetShowTimeWhenMinimized(b : boolean) ;
     procedure TimerOn(Sender : TObject) ;
     procedure TimerOff(Sender : TObject) ;
     procedure ShowCurrentTime(Sender :TObject) ;
     procedure SetInterval(i : integer) ;
     function GetOnActivate : TNotifyEvent ;
     procedure SetOnActivate(t : TNotifyEvent) ;
     function GetOnDeactivate : TNotifyEvent ;
     procedure SetOnDeactivate(t : TNotifyEvent) ;
     function GetOnException : TExceptionEvent ;
     procedure SetOnException(t : TExceptionEvent) ;
     function GetOnHelp : THelpEvent ;
     procedure SetOnHelp(t : THelpEvent) ;
     function GetOnHint : TNotifyEvent ;
     procedure SetOnHint(t : TNotifyEvent) ;
     function GetOnIdle : TIdleEvent ;
     procedure SetOnIdle(t : TIdleEvent) ;
     function GetOnMessage: TMessageEvent ;
     procedure SetOnMessage(t : TMessageEvent) ;
     function GetOnShowHint : TShowHintEvent ;
     procedure SetOnShowHint(t : TShowHintEvent) ;
  protected
     procedure FlashApp(Sender : TObject) ; virtual ;
  public
     property Flashing : boolean read FFlashing write SetFlashing default False ;
     procedure Flash(b: boolean) ;
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
  published
     property FlashInterval : integer read FFlashInterval write SetFlashInterval default 1000 ;
     {$IFDEF WIN32}
     property HintColor : TColor read GetHintColor write SetHintColor default clWhite ;
     property HintPause : integer read GetHintPause write SetHintPause default 500 ;
     property HintHidePause : integer read GetHintHidePause write SetHintHidePause default 2500 ;
     property HintShortPause : integer read GetHintShortPause write SetHintShortPause default 50 ;
     property ShowMainForm :  boolean read GetShowMainForm write SetShowMainForm default True ;
     {$ELSE}
     property HintColor : TColor read GetHintColor write SetHintColor default clYellow ;
     property HintPause : integer read GetHintPause write SetHintPause default 800 ;
     {$ENDIF}
     property Interval : integer read GetInterval write SetInterval default 1000 ;
     property ShowHint :  boolean read GetShowHint write SetShowHint default True ;
     property ShowTimeWhenMinimized : boolean read FShowTimeWhenMinimized
                                              write SetShowTimeWhenMinimized default False ;
     property OnActivate : TNotifyEvent read GetOnActivate write SetOnActivate ;
     property OnDeactivate : TNotifyEvent read GetOnDeactivate write SetOnDeactivate ;
     property OnException : TExceptionEvent read GetOnException write SetOnException ;
     property OnHelp : THelpEvent read GetOnHelp write SetOnHelp ;
     property OnHint : TNotifyEvent read GetOnHint write SetOnHint ;
     property OnIdle : TIdleEvent read GetOnIdle write SetOnIdle ;
     property OnMessage : TMessageEvent read GetOnMessage write SetOnMessage ;
     property OnShowHint : TShowHintEvent read GetOnShowHint write SetOnShowHint ;
     {$IFDEF VER100}
     property UpdateFormatSettings : boolean read GetUpdateFormatSettings
                             write SetUpdateFormatSettings default True ;
     property UpdateMetricSettings : boolean read GetUpdateMetricSettings
                             write SetUpdateMetricSettings default True ;
     {$ENDIF}
  end;

procedure Register;

implementation

constructor TGLAppSettings.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FFlashInterval := 1000 ;
     FTimer := TTimer.Create(self) ;
     FTimer.Enabled := False ;
     FTimer.OnTimer := ShowCurrentTime ;
     {$IFDEF WIN32}
     HintColor := clWhite ;
     {$ELSE}
     HintColor := clYellow ;
     {$ENDIF}
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLAppSettings (1.0) - Copyright  1996 Greg Lief',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

destructor TGLAppSettings.Destroy ;
begin
     FTimer.Free ;
     inherited Destroy ;
end ;

procedure TGLAppSettings.Flash(b : boolean) ;
begin
     if b then begin
        FTimer.Interval := FFlashInterval ;
        FTimer.OnTimer := FlashApp ;
     end
     else begin
        FTimer.OnTimer := ShowCurrentTime ;
        FlashWindow(Application.Handle, False) ;
     end ;
     FTimer.Enabled := b ;
end ;

procedure TGLAppSettings.FlashApp(Sender : TObject) ;
begin
     FlashWindow(Application.Handle, True) ;
end ;

procedure TGLAppSettings.SetFlashing(b : boolean) ;
begin
     FFlashing := b ;
     Flash(b) ;
end ;

procedure TGLAppSettings.SetFlashInterval(i : integer) ;
begin
     if i > 0 then
        FFlashInterval := i ;
end ;

procedure TGLAppSettings.SetHintColor(c : TColor) ;
begin
     Application.HintColor := c ;
end ;

function TGLAppSettings.GetHintColor : TColor ;
begin
     Result := Application.HintColor ;
end ;

function TGLAppSettings.GetHintPause : integer ;
begin
     Result := Application.HintPause ;
end ;

procedure TGLAppSettings.SetHintPause(i : integer) ;
begin
     if i > 0 then
        Application.HintPause := i ;
end ;

function TGLAppSettings.GetOnActivate : TNotifyEvent ;
begin
     Result := Application.OnActivate ;
end ;

procedure TGLAppSettings.SetOnActivate(t : TNotifyEvent) ;
begin
     Application.OnActivate := t ;
end ;

function TGLAppSettings.GetOnDeactivate : TNotifyEvent ;
begin
     Result := Application.OnDeactivate ;
end ;

procedure TGLAppSettings.SetOnDeactivate(t : TNotifyEvent) ;
begin
     Application.OnDeactivate := t ;
end ;

function TGLAppSettings.GetOnException : TExceptionEvent ;
begin
     Result := Application.OnException ;
end ;

procedure TGLAppSettings.SetOnException(t : TExceptionEvent) ;
begin
     Application.OnException := t ;
end ;

function TGLAppSettings.GetOnHelp : THelpEvent ;
begin
     Result := Application.OnHelp ;
end ;

procedure TGLAppSettings.SetOnHelp(t : THelpEvent) ;
begin
     Application.OnHelp := t ;
end ;

function TGLAppSettings.GetOnHint : TNotifyEvent ;
begin
     Result := Application.OnHint ;
end ;

procedure TGLAppSettings.SetOnHint(t : TNotifyEvent) ;
begin
     Application.OnHint := t ;
end ;

function TGLAppSettings.GetOnIdle : TIdleEvent ;
begin
     Result := Application.OnIdle ;
end ;

procedure TGLAppSettings.SetOnIdle(t : TIdleEvent) ;
begin
     Application.OnIdle := t ;
end ;

function TGLAppSettings.GetOnMessage : TMessageEvent ;
begin
     Result := Application.OnMessage ;
end ;

procedure TGLAppSettings.SetOnMessage(t : TMessageEvent) ;
begin
     Application.OnMessage := t ;
end ;

function TGLAppSettings.GetOnShowHint : TShowHintEvent ;
begin
     Result := Application.OnShowHint ;
end ;

procedure TGLAppSettings.SetOnShowHint(t : TShowHintEvent) ;
begin
     Application.OnShowHint := t ;
end ;


{$IFDEF WIN32}

function TGLAppSettings.GetHintHidePause : integer ;
begin
     Result := Application.HintHidePause ;
end ;

procedure TGLAppSettings.SetHintHidePause(i : integer) ;
begin
     if i > 0 then
        Application.HintHidePause := i ;
end ;

function TGLAppSettings.GetHintShortPause : integer ;
begin
     Result := Application.HintShortPause ;
end ;

procedure TGLAppSettings.SetHintShortPause(i : integer) ;
begin
     if i > 0 then
        Application.HintShortPause := i ;
end ;

function TGLAppSettings.GetShowMainForm : boolean ;
begin
     Result := Application.ShowMainForm ;
end ;

procedure TGLAppSettings.SetShowMainForm(b : boolean) ;
begin
     Application.ShowMainForm := b ;
end ;

{$ENDIF}

{$IFDEF VER100}

function TGLAppSettings.GetUpdateFormatSettings : boolean ;
begin
     Result := Application.UpdateFormatSettings ;
end ;

procedure TGLAppSettings.SetUpdateFormatSettings(b : boolean) ;
begin
     Application.UpdateFormatSettings := b ;
end ;

function TGLAppSettings.GetUpdateMetricSettings : boolean ;
begin
     Result := Application.UpdateMetricSettings ;
end ;

procedure TGLAppSettings.SetUpdateMetricSettings(b : boolean) ;
begin
     Application.UpdateMetricSettings := b ;
end ;

{$ENDIF}

function TGLAppSettings.GetShowHint : boolean ;
begin
     Result := Application.ShowHint ;
end ;

procedure TGLAppSettings.SetShowHint(b : boolean) ;
begin
     Application.ShowHint := b ;
end ;

procedure TGLAppSettings.SetShowTimeWhenMinimized(b : boolean) ;
begin
     FShowTimeWhenMinimized := b ;
     if b then begin
        Application.OnMinimize := TimerOn  ;
        Application.OnRestore  := TimerOff ;
     end
     else begin
        Application.OnMinimize := nil ;
        Application.OnRestore  := nil ;
     end ;
end ;

procedure TGLAppSettings.TimerOn(Sender :TObject) ;
begin
     FOldTitle := Application.Title ;
     FTimer.Enabled := True ;
end ;

procedure TGLAppSettings.TimerOff(Sender :TObject) ;
begin
     FTimer.Enabled := False ;
     Application.Title := FOldTitle ;
end ;

procedure TGLAppSettings.ShowCurrentTime(Sender :TObject) ;
begin
     Application.Title := TimeToStr(Time) ;
end ;

function TGLAppSettings.GetInterval : integer ;
begin
     Result := FTimer.Interval ;
end ;

procedure TGLAppSettings.SetInterval(i : integer) ;
begin
     if (not FShowTimeWhenMinimized) and (csDesigning in ComponentState) then
        ShowMessage('Timer not enabled!') ;
     FTimer.Interval := i ;
end ;

procedure Register;
begin
  RegisterComponents('Greg Lief', [TGLAppSettings]);
end;

end.
