unit srchedit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  DBTables, { for TTable }
  DsgnIntf, { for property editor-related things }
  DB        { necessary for TLocateOption settings }
  ;

type
  TMyFieldName = string[100] ;

  TMyFieldNameEditor = Class(TStringProperty)
    function  GetAttributes : TPropertyAttributes; override;
    procedure GetValues(Proc : TGetStrProc) ;      override;
  end;

  TGLSearchEdit = class(TEdit)
  private
     FBeepOnBadKey : boolean ;
     FTable : TTable ;
     FFieldName : TMyFieldName ;
  protected
     procedure Change ; override ;
     procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent) ; override ;
  published
     property BeepOnBadKey : boolean read FBeepOnBadKey write FBeepOnBadKey default False ;
     property Table : TTable read FTable write FTable ;
     property FieldName : TMyFieldName read FFieldName write FFieldName ;
  end;

procedure Register;

implementation

constructor TGLSearchEdit.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLSearchEdit (1.01) - Copyright  1998 Greg Lief',
                   mtInformation, [mbOK], 0) ;
{$ENDIF}
end;

procedure TGLSearchEdit.Notification(AComponent: TComponent; Operation: TOperation);
begin
   if (Operation = opRemove) and (AComponent = FTable) then
      FFieldName := '' ;
end ;

procedure TGLSearchEdit.Change ;
begin
     inherited Change ;
     if (FTable <> nil) and (FFieldName <> '') then
        with FTable do
           if Text = '' then
              First 
           else if not Locate( FFieldName, Text, [loCaseInsensitive, loPartialKey] ) then begin
              if FBeepOnBadKey then MessageBeep(0) ;
              Text := Copy(Text, 1, Length(Text) - 1) ;
              SelStart := Length(Text) ;
           end ;
end ;

function TMyFieldNameEditor.GetAttributes : TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paValueList,paSortList] ;
end;

procedure TMyFieldNameEditor.GetValues(Proc: TGetStrProc);
var
  x : integer ;
  HadToOpen : boolean ;
begin
     with (GetComponent(0) as TGLSearchEdit).FTable do begin
        HadToOpen := not Active ;
        if HadToOpen then
           Open ;
        for x := 0 to FieldDefs.Count - 1 do
           Proc(FieldDefs[x].Name) ;
        if HadToOpen then
           Close ;
     end ;
end;

procedure Register;
begin
  RegisterComponents('GLAD: Database', [TGLSearchEdit]);
  RegisterPropertyEditor( TypeInfo(TMyFieldName), TGLSearchEdit, 'FieldName', TMyFieldNameEditor);
end;

end.
