unit Gridsave ;

{$DEFINE USE_INIFILE}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBGrids,
  {$IFDEF USE_INIFILE}
  IniFiles  { for TIniFile }
  {$ELSE}
  WinReg    { for TWinRegistry }
  {$ENDIF}
  ;

type
  TGLGridSave = class(TComponent)
  private
     FGrid : TDBGrid ;
     {$IFDEF USE_INIFILE}
     FIniFile : TIniFile ;
     FIniFileName : string ;
     procedure SetIniFileName(s : string) ;
     {$ELSE}
     FIniFile : TWinRegistry ;
     FRegistryKey : string ;
     {$ENDIF}
     procedure SetGrid(g : TDBGrid) ;
  protected
     procedure Notification(AComponent: TComponent; Operation: TOperation);
  public
     constructor Create(AOwner : TComponent) ; override ;
     procedure ClearSettings ;
     procedure Load ;
     procedure Save ;
  published
     property Grid : TDBGrid read FGrid write SetGrid ;
     {$IFDEF USE_INIFILE}
     property IniFileName : string read FiniFileName write SetIniFileName ;
     {$ELSE}
     property RegistryKey : string read FRegistryKey write FRegistryKey ;
     {$ENDIF}
  end;

{$IFNDEF USE_INI_FILE}
const
     MAIN_REGISTRY_KEY = 'Software' ;
     SECTION = 'Greg Lief' ;
{$ENDIF}

procedure Register;

implementation

constructor TGLGridSave.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLGridSave 1.02 - Copyright  1998 Greg Lief' + #13 + 'This component is part of the G.L.A.D. collection' + #13 + 'To remove this message and receive the source code, ' + #13 + 'register at http://www.greglief.com/delphi.shtml',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

procedure TGLGridSave.SetIniFileName(s : string) ;
begin
     if s <> FIniFileName then begin
        if ( ExtractFileExt( s ) = '' ) and ( s <> '' ) then
           s := s + '.ini' ;
        FIniFileName := s ;
     end ;
end ;

procedure TGLGridSave.SetGrid(g : TDBGrid) ;
begin
     FGrid := g ;
     if FGrid <> nil then begin
        {$IFDEF USE_INIFILE}
        if FIniFileName = '' then
           FIniFileName := FGrid.Name + '.ini' ;
        {$ELSE}
        if FRegistryKey = '' then
           FRegistryKey := FGrid.Name ;
        {$ENDIF}
     end ;
end ;

procedure TGLGridSave.Notification(AComponent: TComponent;
          Operation: TOperation);
begin
     if (AComponent = FGrid) and (Operation = opRemove) then begin
        FGrid := nil ;
        {$IFDEF USE_INIFILE}
        FIniFileName := '' ;
        {$ELSE}
        FRegistryKey := '' ;
        {$ENDIF}
     end ;
end ;

procedure TGLGridSave.Load ;
var
   x : integer ;
begin
     if (FGrid <> nil) and (FGrid.Columns <> nil) then begin

     {$IFDEF USE_INIFILE}
     FIniFile := TIniFile.Create(ExtractFilePath(ParamStr(0)) + FIniFileName) ;
     if FileExists(ExtractFilePath(ParamStr(0)) + FIniFileName) then begin
     {$ELSE}
     FIniFile := TWinRegistry.Create(MAIN_REGISTRY_KEY+ '\' + SECTION + '\' + FRegistryKey) ;
     { there must be a cleaner way to test for the
       existence of a key -- if you find it, let me know }
     if (FIniFile.ReadString('Column0','FieldName','<none>') <> '<none>') then begin
     {$ENDIF}
        x := 0 ;
        with FGrid do begin
           Columns.Clear ;
           while (x < 1000) and
              (FIniFile.ReadString('Column' + IntToStr(x),'Fieldname', '???') <> '???') do begin
              Columns.Add ;
              Columns[x].FieldName := FIniFile.ReadString('Column' + IntToStr(x),
                                      'Fieldname',
                                      Columns[x].FieldName) ;
              Columns[x].Width :=  FIniFile.ReadInteger('Column' + IntToStr(x),
                                   'Width', Columns[x].Width) ;
              Columns[x].Title.Caption := FIniFile.ReadString('Column' + IntToStr(x),
                                   'Title', Columns[x].Title.Caption) ;
              Columns[x].Color := FIniFile.ReadInteger('Column' + IntToStr(x),
                                   'Color', Columns[x].Color) ;
              Inc(x) ;
           end ;  { while (x < 1000) ... do begin }
        end ;  { with FGrid do }
     end ;

     FIniFile.Free ;

     end ; { if (FGrid <> nil) ... then begin }

end ;

procedure TGLGridSave.Save ;
var
   x : integer ;
begin
     { the third boolean expression in the next statement is to ensure against an empty grid }
     if (FGrid <> nil) and (FGrid.Columns <> nil) and (FGrid.Columns[0].FieldName <> '') then begin
     {$IFDEF USE_INIFILE}
     FIniFile := TIniFile.Create(ExtractFilePath(ParamStr(0)) + FIniFileName) ;
     {$ELSE}
     FIniFile := TWinRegistry.Create(MAIN_REGISTRY_KEY + '\' + SECTION + '\' + FRegistryKey) ;
     {$ENDIF}
     with FGrid do
        for x := 0 to Columns.Count - 1 do begin
           FIniFile.WriteString('Column' + IntToStr(x),
                                'Fieldname',
                                Columns[x].FieldName) ;
           FIniFile.WriteInteger('Column' + IntToStr(x),
                                 'Width',
                                 Columns[x].Width) ;
           FIniFile.WriteString('Column' + IntToStr(x),
                                'Title',
                                Columns[x].Title.Caption) ;
           FIniFile.WriteInteger('Column' + IntToStr(x),
                                 'Color',
                                 Columns[x].Color) ;
        end ;  { for x ... }

        FIniFile.Free ;

     end ; { if (FGrid <> nil) ... then begin }

end ;


procedure TGLGridSave.ClearSettings ;
begin
     {$IFDEF USE_INIFILE}
     DeleteFile(ExtractFilePath(ParamStr(0)) + FIniFileName) ;
     {$ELSE}
     FIniFile := TWinRegistry.Create(MAIN_REGISTRY_KEY+ '\' + SECTION) ;
     FIniFile.EraseSection(FRegistryKey) ;
     FIniFile.Free ;
     {$ENDIF}
end ;


procedure Register;
begin
     RegisterComponents('GLAD: DBGrids', [TGLGridSave]);
end;

end.
