unit fd_form;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB, Buttons, Menus ;

type
  TGLDragDropListBox = class(TListBox)
  public
     procedure KeyDown(var Key : Word ; Shift: TShiftState) ; override ;
     procedure MouseDown(Button: TMouseButton;
               Shift: TShiftState; X, Y: Integer); override ;
     procedure DragOver(Source: TObject; X, Y: Integer;
               State: TDragState; var Accept: Boolean); override ;
     procedure DragDrop(Source: TObject; X, Y: Integer); override ;
  end ;

  TGLFieldSelectionDialog = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    UpButton: TBitBtn;
    DownButton: TBitBtn;
    PopupMenu1: TPopupMenu;
    InsertFields1: TMenuItem;
    InsertButton: TBitBtn;
    DeleteButton: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure UpButtonClick(Sender: TObject);
    procedure DownButtonClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure InsertFields1Click(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
  private
    FDataSet : TDataSet ;
    procedure ListBoxClick(Sender: TObject);
    procedure InsertFields ;
    procedure RefreshButtons ;
    procedure SetDataSet( d : TDataSet );
  public
    ListBox : TGLDragDropListBox ;
    ValidDataTypes : set of TFieldType ;
    property DataSet : TDataSet read FDataSet write SetDataSet ;
  end;

implementation

{$R *.DFM}

procedure TGLFieldSelectionDialog.FormCreate(Sender: TObject);
begin
     ListBox := TGLDragDropListBox.Create(self) ;
     ListBox.Height := 160 ;
     ListBox.Align := alTop ;
     ListBox.Parent := self ;
     ListBox.OnClick := ListBoxClick ;
     ListBox.PopupMenu := PopupMenu1 ;
     DataSet := nil ;
     ValidDataTypes := [] ;   // a null set means that all data types are valid
     ActiveControl := ListBox ;
end;

procedure TGLFieldSelectionDialog.SetDataSet( d : TDataSet );
begin
     if FDataSet <> d then begin
        FDataSet := d ;
        if FDataSet <> nil then
           FDataSet.FieldDefs.Update ;
     end ;      
end ;

procedure TGLFieldSelectionDialog.ListBoxClick(Sender: TObject);
begin
     RefreshButtons ;
end ;

procedure TGLFieldSelectionDialog.RefreshButtons ;
begin
     UpButton.Enabled := (ListBox.ItemIndex > 0) ;
     DownButton.Enabled := (ListBox.ItemIndex < ListBox.Items.Count - 1) ;
     InsertButton.Enabled := (ListBox.Items.Count < FDataSet.FieldDefs.Count) ;
     DeleteButton.Enabled := (ListBox.Items.Count > 0) ;
end ;

{ begin TGLDragDropListBox logic }

procedure TGLDragDropListBox.KeyDown(var Key : Word ; Shift: TShiftState) ;
var
   i : integer ;
begin
     if Key = vk_Delete then begin
        i := ItemIndex ;
        Items.Delete(ItemIndex) ;
        if i = Items.Count then
           ItemIndex := Items.Count - 1
        else
           ItemIndex := i ;
        Click ;  // force buttons to refresh
     end ;
end ;

procedure TGLDragDropListBox.MouseDown(Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
      if Button = mbLeft then
         BeginDrag(False) ;
end;

procedure TGLDragDropListBox.DragOver(Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
     Accept := (Source = self) ;
end;

procedure TGLDragDropListBox.DragDrop(Source: TObject; X, Y: Integer);
var
   s : string ;
begin
     s := Items[ItemIndex] ;
     Items.Delete(ItemIndex) ;
     Items.Insert(ItemAtPos( Point(X, Y), True), s) ;
end;

{ end TGLDragDropListBox logic }

procedure TGLFieldSelectionDialog.UpButtonClick(Sender: TObject);
var
   s : string ;
   i : integer ;
begin
     with ListBox do begin
        s := Items[ItemIndex] ;
        i := ItemIndex ;
        Items.Delete(ItemIndex) ;
        Items.Insert(i - 1, s) ;
        ItemIndex := i - 1 ;
     end ;
     RefreshButtons ;
end;

procedure TGLFieldSelectionDialog.DownButtonClick(Sender: TObject);
var
   s : string ;
   i : integer ;
begin
     with ListBox do begin
        s := Items[ItemIndex] ;
        i := ItemIndex ;
        Items.Delete(ItemIndex) ;
        Items.Insert(i + 1, s) ;
        ItemIndex := i + 1 ;
        Click ;  { force enabling/disabling of up/down buttons }
     end ;
end;

procedure TGLFieldSelectionDialog.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     if Key = vk_Insert then begin
        Key := 0 ;
        InsertFields ;
     end ;
end;

procedure TGLFieldSelectionDialog.InsertFields ;
var
   f : TGLFieldSelectionDialog ;
   x : integer ;
   Pos : integer ;
   HadToOpen : boolean ;
begin
     f := TGLFieldSelectionDialog.Create(nil) ;
     f.UpButton.Visible := False ;
     f.DownButton.Visible := False ;
     f.InsertButton.Visible := False ;
     f.DeleteButton.Visible := False ;
     f.DataSet := FDataSet ;
     f.OnKeyDown := nil ;
     f.Position := poDesigned ;
     f.Top := Top + 50 ;
     f.Left := Left + 50 ;
     f.Height := f.Height - 56 ;
     f.Caption := 'Insert Fields' ;
     f.ListBox.MultiSelect := True ;
     { load listbox with only those string fields which
       are NOT already present in the list }
     HadToOpen := (FDataSet.FieldCount = 0) and (not FDataSet.Active) ;
     if HadToOpen then
        FDataSet.Open ;

     for x := 0 to FDataSet.FieldCount - 1 do
        if ((ValidDataTypes = []) or
            (FDataSet.Fields[x].DataType in ValidDataTypes)) and
            (ListBox.Items.IndexOf(FDataSet.Fields[x].FieldName) = -1) then begin
           f.ListBox.Items.Add(FDataSet.Fields[x].FieldName) ;
           f.ListBox.Selected[f.ListBox.Items.Count - 1] := True ;
        end ;

     if HadToOpen then
        FDataSet.Close ;

     if f.ListBox.Items.Count = 0 then begin
        MessageDlg('No fields available for insertion', mtError, [mbOK], 0) ;
        f.Release ;
     end
     else
        try
           if (f.ShowModal = mrOK) and (f.ListBox.SelCount > 0) then begin
              Pos := 1 ;
              for x := 0 to f.ListBox.Items.Count - 1 do
                 if f.ListBox.Selected[x] then begin
                    ListBox.Items.Insert(ListBox.ItemIndex + Pos, f.ListBox.Items[x]) ;
                    Inc(Pos) ;
                 end ;
           end ;
        finally
           f.Release ;
        end ;

end;

procedure TGLFieldSelectionDialog.InsertFields1Click(Sender: TObject);
begin
     InsertFields ;
end;

procedure TGLFieldSelectionDialog.DeleteButtonClick(Sender: TObject);
var
   Dummy : word ;
begin
     Dummy := vk_Delete ;
     ListBox.KeyDown( Dummy, [] ) ;
end;

end.
