unit elastic;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Grids, DBCtrls, Mask, ComCtrls, DBCGrids ;

type
  TGLElastic = class(TComponent)
  private
     FAdjustLabelWidths : boolean ;
     FEnabled : boolean ;
     FOldHeight : integer ;
     FOldWidth : integer ;
     FOldOnResize : TNotifyEvent ;
     FOnResize : TNotifyEvent ;
     FFixed : TStringList ;
     procedure SetEnabled(b : boolean) ;
     procedure SetFixed(s : TStringList) ;
  protected
     procedure FormResize(Sender : TObject) ;
  public
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
  published
     property AdjustLabelWidths : boolean read FAdjustLabelWidths write FAdjustLabelWidths default False ;
     property Enabled : boolean read FEnabled write SetEnabled default True ;
     property FixedComponents : TStringList read FFixed write SetFixed ;
     property OnResize : TNotifyEvent read FOnResize write FOnResize ;
  end;

procedure Register;

implementation

constructor TGLElastic.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FEnabled := True ;
     FFixed := TStringList.Create ;
{$IFDEF SHOW_COPYRIGHT}
     ShowCopyright(self,True) ;
{$ENDIF}
     if not (csDesigning in ComponentState) then begin
        FOldHeight := TForm(AOwner).Height;
        FOldWidth := TForm(AOwner).Width ;
        FOldOnResize := TForm(AOwner).OnResize ;
        TForm(AOwner).OnResize := FormResize ;
     end ;
end ;

destructor TGLElastic.Destroy ;
begin
     FFixed.Free ;
     inherited Destroy ;
end ;

procedure TGLElastic.SetFixed(s : TStringList) ;
begin
     FFixed.Assign( s ) ;
     FFixed.Text := UpperCase( FFixed.Text ) ;
end ;

procedure TGLElastic.SetEnabled(b : boolean) ;
begin
  FEnabled := b ;
  FOldHeight := TForm(Owner).Height;
  FOldWidth := TForm(Owner).Width ;
end ;

procedure TGLElastic.FormResize(Sender: TObject);
var
   x, y : integer ;
   Ratio : real ;
begin
     if FEnabled then
        with Owner as TForm do begin
           LockWindowUpdate(Handle) ;
           for x := 0 to ComponentCount - 1 do begin
              if (Components[x] is TWinControl) and (FFixed.IndexOf(UpperCase(Components[x].ClassName)) = -1) then begin
                 if Height <> FOldHeight then begin
                    Ratio := Height / FOldHeight ;
                    with TWinControl(Components[x]) do begin
                       Top := Round(Ratio * Top) ;
                       Height := Round(Ratio * Height) ;
                    end ;
                    if Components[x] is TEdit then
                       with TEdit(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TCheckBox then
                       with TCheckBox(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TDBCheckBox then
                       with TDBCheckBox(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TDBEdit then
                       with TDBEdit(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TMemo then
                       with TMemo(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TRichEdit then
                       with TRichEdit(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TDBMemo then
                       with TDBMemo(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TDBCtrlGrid then
                       with TDBCtrlGrid(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TMaskEdit then
                       with TMaskEdit(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TListBox then
                       with TListBox(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TDBListBox then
                       with TDBListBox(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TComboBox then
                       with TComboBox(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TDBComboBox then
                       with TDBComboBox(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TButton then
                       with TButton(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TRadioButton then
                       with TRadioButton(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TRadioGroup then
                       with TRadioGroup(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TDBRadioGroup then
                       with TDBRadioGroup(Components[x]).Font do
                          Size := Round(Ratio * Size)
                    else if Components[x] is TStringGrid then
                       with TStringGrid(Components[x]) do begin
                          Font.Size := Round(Ratio * Font.Size) ;
                          for y := 0 to RowCount - 1 do
                             RowHeights[y] := Round(Ratio * RowHeights[y]) ;
                       end ;
                    {$IFDEF VER120}
                    if Components[x] is TToolBar then
                       TToolBar(Components[x]).ButtonHeight := Round(Ratio * TToolBar(Components[x]).ButtonHeight) ;
                    {$ENDIF}
                 end ;
                 if Width <> FOldWidth then begin
                    Ratio := Width / FOldWidth ;
                    TWinControl(Components[x]).Left := Round(Ratio * TWinControl(Components[x]).Left) ;
                    TWinControl(Components[x]).Width  := Round(Ratio * TWinControl(Components[x]).Width) ;
                    if (Components[x] is TStringGrid) and (Width <> FOldWidth) then
                       with TStringGrid(Components[x]) do
                          for y := 0 to ColCount - 1 do
                             ColWidths[y] := Round(Ratio * ColWidths[y]) ;
                    {$IFDEF VER120}
                    if Components[x] is TToolBar then
                       TToolBar(Components[x]).ButtonWidth := Round(Ratio * TToolBar(Components[x]).ButtonWidth) ;
                    {$ENDIF}
                 end ;
              end
              else if (Components[x] is TGraphicControl) 
                   {$IFDEF VER120}
                   and (not (Components[x] is TToolButton) ) 
                   {$ENDIF}
                   and (FFixed.IndexOf(UpperCase(Components[x].ClassName)) = -1) then begin
                 if Height <> FOldHeight then begin
                    Ratio := Height / FOldHeight ;
                    with TGraphicControl(Components[x]) do begin
                       Top := Round(Ratio * Top) ;
                       Height := Round(Ratio * Height) ;
                    end ;
                    if Components[x] is TLabel then
                       TLabel(Components[x]).Font.Size := Round(Ratio * TLabel(Components[x]).Font.Size)
                    else if Components[x] is TDBText then
                       TDBText(Components[x]).Font.Size := Round(Ratio * TDBText(Components[x]).Font.Size) ;
                 end ;
                 if Width <> FOldWidth then begin
                    Ratio := Width / FOldWidth ;
                    with TGraphicControl(Components[x]) do
                       Left := Round(Ratio * Left) ;
                    if (not (Components[x] is TLabel)) or FAdjustLabelWidths then
                       with TGraphicControl(Components[x]) do
                          Width := Round(Ratio * Width) ;
                 end ;
              end ;
           end ;
           FOldHeight := Height ;
           FOldWidth := Width ;
           if Assigned(FOnResize) then FOnResize(Owner) ;
           LockWindowUpdate(0) ;
        end ;
     if Assigned(FOldOnResize) then FOldOnResize(Owner) ;
end;

procedure Register;
begin
  RegisterComponents('GLAD: Misc.', [TGLElastic]);
end;

end.
