unit GLSupp ;

interface

uses
  Classes,
  Messages,
  ExtCtrls,
  Forms,
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes, WinProcs,
{$ENDIF}
  Dialogs ;

procedure GLConvertString(Component : TComponent ; Dummy : boolean) ;

implementation

type
   TGLDummy = class
   public
      Form : TForm ;
      OriginalFormCaption : string ;
      Timer : TTimer ;
      procedure TimerEvent(Sender : TObject) ;
      procedure TimerEvent2(Sender : TObject) ;
   end ;

var
   FDummy : TGLDummy ;

const
   Hits : integer = 0 ;

procedure GLConvertString(Component : TComponent ; Dummy : boolean) ;
var
   Temp : string ;
   x : integer ;
begin
     if not Dummy then Halt ;

     { design-time }
     if csDesigning in Component.ComponentState then begin
        Temp := ':T::JL:\llj:::::ڼ' +
               ':::VV|VV:VV|VV::' +
               '::::PP~::R::' +
               '::::¼V:R::nXX' +
               'VVXҼ' ;
        for x := 1 to Length(Temp) do
           Temp[x] := Chr((Ord(Temp[x]) + 6) shr 1) ;
        MessageDlg(Component.ClassName + Temp, mtInformation, [mbOK], 0) ;
     end 

     { run-time }
     else begin

        Inc(Hits) ;

        if FDummy = nil then
           FDummy := TGLDummy.Create ;

        { show copyright notice first time and then every 10th time }
        if (Hits = 1) or (Hits mod 10 = 0) then

           { run-time with Delphi IDE running }
           if ((FindWindow('TAppBuilder', nil) <> 0) or
              (FindWindow('TEditWindow', nil) <> 0) or
              (FindWindow('TProjectManager', nil) <> 0) or
              (FindWindow('TProjectManagerForm', nil) <> 0) or
              (FindWindow('TPropertyInspector', nil) <> 0) or
              (FindWindow('TAlignPalette', nil) <> 0) or
              (FindWindow('TMenuBuilder', nil) <> 0)) and
              (Component.Owner is TForm) then begin

              if (FDummy.Timer = nil) or (not FDummy.Timer.Enabled) then begin
                 Temp := ':::VV|VV' ;
                 for x := 1 to Length(Temp) do
                    Temp[x] := Chr((Ord(Temp[x]) + 6) shr 1) ;
                 FDummy.Form := TForm(Component.Owner) ;
                 FDummy.OriginalFormCaption := TForm(Component.Owner).Caption ;
                 FDummy.Form.Caption := FDummy.OriginalFormCaption + Temp ;
                 FDummy.Timer := TTimer.Create(nil) ;
                 FDummy.Timer.Enabled := False ;
                 FDummy.Timer.OnTimer := FDummy.TimerEvent ;
                 FDummy.Timer.Interval := 3000 ;
                 FDummy.Timer.Enabled := True ;
              end

           end
           { run-time with Delphi IDE not running }
           else begin
              Temp := '::::::VV|VV:' +
                      ':<::::' +
                      ':VV|VVR::nXXVVXҼ' ;
              for x := 1 to Length(Temp) do
                 Temp[x] := Chr((Ord(Temp[x]) + 6) shr 1) ;
              FDummy.Timer := TTimer.Create(nil) ;
              FDummy.Timer.Enabled := False ;
              FDummy.Timer.OnTimer := FDummy.TimerEvent2 ;
              FDummy.Timer.Interval := 4000 ;
              FDummy.Timer.Enabled := True ;
              MessageDlg(Temp, mtInformation, [mbOK], 0) ;
           end ;

     end ;

end;

procedure TGLDummy.TimerEvent(Sender : TObject) ;
begin
     (Sender as TTimer).Enabled := False ;
     FDummy.Form.Caption := FDummy.OriginalFormCaption ;
end ;

procedure TGLDummy.TimerEvent2(Sender : TObject) ;
begin
     (Sender as TTimer).Enabled := False ;
     SendMessage( FindWindow(nil, 'Information'), WM_CLOSE, 0, 0) ;
end ;

end.
