// NOTE: THIS DOES NOT WORK WITH PARADOX FILES!!!!!!!!

unit glprogrs ;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  BDE,
  ComCtrls ,
  DBTables, StdCtrls, Buttons ;

type
  TGLProgressOption = (glpAllowAbort,
                       glpDefaultBatchmoveStatus,
                       glpPercentInCaption,
                       glpTitle) ;
  TGLProgressOptions = set of TGLProgressOption ;

  TProgressForm = class(TForm)
    Bar: TProgressBar;
    btnCancel: TBitBtn;
    UserMessage: TLabel;
    procedure btnCancelClick(Sender: TObject);
  private
    OriginalFormHeight : integer ;
    OriginalButtonTop  : integer ;
  public
    AbortMessage : string ;
    CancelDetected : boolean ;
    Delay : integer ;
    InfoBuff : cbProgressDesc ;
    Options : TGLProgressOptions ;
    Title : string ;
    TotalRecords : integer ;
    procedure Reset ;
  end ;

  TGLProgress = class(TComponent)
  private
     FAbortMessage : string ;
     FDelay : integer ;
     FOptions : TGLProgressOptions ;
     FTable : TTable ;
     FTitle : string ;
     FUserMessage : string ;
     procedure SetAbortMessage(s : string) ;
     procedure SetDelay(i : integer) ;
     procedure SetTitle(s : string) ;
     procedure SetOptions(o : TGLProgressOptions) ;
     procedure SetUserMessage(s : string) ;
  protected
     procedure Loaded ; override ;
     procedure Notification(AComponent : TComponent ; Operation : TOperation) ; override ;
  public
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
     procedure SetTotalRecords ;
  published
     property AbortMessage : string read FAbortMessage write SetAbortMessage ;
     property Delay : integer read FDelay write SetDelay default 500 ;
     property Options : TGLProgressOptions read FOptions write SetOptions
              default [glpAllowAbort, glpDefaultBatchmoveStatus,
                       glpPercentInCaption, glpTitle] ;
     property Table : TTable read FTable write FTable ;
     property Title : string read FTitle write SetTitle ;
     property UserMessage : string read FUserMessage write SetUserMessage ;
  end;

procedure Register;

implementation

(*
   NOTE: The progress form must be a free-standing variable,
         rather than a property of the component, so that it
         will be visible to the callback function.  Accordingly,
         the properties of the component are "mirrored" by
         properties in the form -- assigning values to the
         component's properties also assigns the form's
         properties.  This all happens automatically, but
         I thought you might like some explanation of the
         rationale behind this.
*)
var
   ProgressForm : TProgressForm ;

{$R *.DFM}

function GLShowProgress(ebcType : CBType ; iClientData : longint ;
         CbInfo : Pointer) : cbrType ; stdcall ; forward ;

constructor TGLProgress.Create(AOwner : TComponent) ;
begin
     inherited ;
     FAbortMessage := 'Cancel this operation?' ;
     FDelay := 500 ;
     FOptions := [glpAllowAbort,
                  glpDefaultBatchmoveStatus,
                  glpPercentInCaption,
                  glpTitle] ;
     FTitle := 'Indexing Progress' ;
end ;

destructor TGLProgress.Destroy ;
begin
     if (FTable <> nil) and FTable.Active then
        Check( DBIRegisterCallBack( FTable.Handle,
                                    cbGENPROGRESS,
                                    0,
                                    SizeOf(cbProgressDesc),
                                    @ProgressForm.InfoBuff,
                                    nil) ) ;
     ProgressForm.Free ;
     inherited ;
end ;

procedure TGLProgress.Notification(AComponent : TComponent ; Operation : TOperation) ;
begin
     if (AComponent = FTable) and (Operation = opRemove) then
        FTable := nil ;
end ;

procedure TGLProgress.SetAbortMessage(s : string) ;
begin
     FAbortMessage := s ;
     if ProgressForm <> nil then
        ProgressForm.AbortMessage := s ;
end ;

procedure TGLProgress.SetTitle(s : string) ;
begin
     FTitle := s ;
     if ProgressForm <> nil then
        ProgressForm.Title := s ;
end ;

procedure TGLProgress.SetUserMessage(s : string) ;
begin
     FUserMessage := s ;
     if ProgressForm <> nil then
        ProgressForm.UserMessage.Caption := s ;
end ;

procedure TGLProgress.SetDelay(i : integer) ;
begin
     if i > 0 then begin
        FDelay := i ;
        if ProgressForm <> nil then
           ProgressForm.Delay := i ;
     end ;
end ;

procedure TGLProgress.SetOptions(o : TGLProgressOptions) ;
begin
     FOptions := o ;
     if ProgressForm <> nil then
        ProgressForm.Options := o ;
end ;

procedure TGLProgress.Loaded ;
begin
     inherited ;
     if (not (csDesigning in ComponentState)) and (FTable <> nil) then begin
        ProgressForm := TProgressForm.Create(self) ;
        ProgressForm.OriginalFormHeight := ProgressForm.Height ;
        ProgressForm.OriginalButtonTop := ProgressForm.btnCancel.Top ;
        ProgressForm.AbortMessage := FAbortMessage ;
        ProgressForm.Delay := FDelay ;
        ProgressForm.Title := FTitle ;
        ProgressForm.Options := FOptions ;
        ProgressForm.UserMessage.Caption := FUserMessage ;

        DbiInit(nil) ;
        Check( DBIRegisterCallBack( FTable.Handle,
                                    cbGENPROGRESS,
                                    0,
                                    SizeOf(cbProgressDesc),
                                    @ProgressForm.InfoBuff,
                                    @GLShowProgress ) ) ;
     end ;
end ;

procedure TGLProgress.SetTotalRecords ;
var
   HadToOpen : boolean ;
begin
     if (ProgressForm <> nil) and (FTable <> nil) then begin
        HadToOpen := not FTable.Active ;
        if HadToOpen then
           FTable.Open ;
        ProgressForm.TotalRecords := FTable.RecordCount ;
        if HadToOpen then
           FTable.Close ;
     end ;
end ;

function GLShowProgress(ebcType : CBType ; iClientData : longint ;
                        CbInfo : Pointer) : cbrType ;
var
  temp : integer ;
  Percentage : integer ;
  Msg : string ;
  MsgLen : integer ;
  AddParentheses : boolean ;
begin
     if not ProgressForm.Visible then begin
        ProgressForm.btnCancel.Visible := (glpAllowAbort in ProgressForm.Options) ;

        if not ProgressForm.btnCancel.Visible then
           ProgressForm.Height := ProgressForm.Height - ProgressForm.btnCancel.Height ;

        ProgressForm.UserMessage.Visible := (ProgressForm.UserMessage.Caption <> '') ;

        if not ProgressForm.UserMessage.Visible then begin
           ProgressForm.Height := ProgressForm.Height - ProgressForm.UserMessage.Height ;
           if ProgressForm.btnCancel.Visible then
              ProgressForm.btnCancel.Top := ProgressForm.btnCancel.Top - ProgressForm.UserMessage.Height ;
        end ;

        ProgressForm.CancelDetected := False ;
        ProgressForm.Show ;
        ProgressForm.Update ;
     end ;

     if ProgressForm.btnCancel.Visible then begin
        Application.ProcessMessages ;
        if ProgressForm.CancelDetected then
           if (MessageDlg(ProgressForm.AbortMessage, mtConfirmation, [mbYes,mbNo], 0) = mrYes) then begin
              Result := cbrABORT ;
              ProgressForm.Reset ;
              exit ;
           end
           else
              ProgressForm.CancelDetected := False ;
     end ;

     if ProgressForm.InfoBuff.iPercentDone >= 0 then begin
        Percentage := ProgressForm.InfoBuff.iPercentDone ;

        // build form caption based upon selected options
        if glpTitle in ProgressForm.Options then
           Msg := ProgressForm.Title
        else
           Msg := '' ;
        if glpPercentInCaption in ProgressForm.Options then begin
           AddParentheses := (Msg <> '') ;
           if AddParentheses then
              Msg := Msg + ' (' ;
           Msg := Msg + IntToStr(Percentage) + '%' ;
           if AddParentheses then
              Msg := Msg + ')' ;
        end ;
        ProgressForm.Caption := Msg ;

        ProgressForm.Bar.Position := Percentage ;
     end
     else if ProgressForm.TotalRecords > 0 then begin
        MsgLen := Length(ProgressForm.InfoBuff.szMsg) ;
        temp := Pos(':', ProgressForm.InfoBuff.szMsg) ;
        Percentage := 100 * StrToInt(Copy(ProgressForm.InfoBuff.szMsg, temp + 1, MsgLen - temp + 1))
                      div ProgressForm.TotalRecords ;

        // build form caption based upon selected options
        if glpDefaultBatchmoveStatus in ProgressForm.Options then begin
           // if developer provided an alternate title, use that
           // instead of the first part of the default batchmove status
           // (e.g., "Records Appended:")
           if glpTitle in ProgressForm.Options then
              Msg := ProgressForm.Title + Copy(ProgressForm.InfoBuff.szMsg, temp, MsgLen - temp + 1)
           else
              Msg := ProgressForm.InfoBuff.szMsg
        end
        else if glpTitle in ProgressForm.Options then
           Msg := ProgressForm.Title
        else
           Msg := '' ;
        if glpPercentInCaption in ProgressForm.Options then begin
           AddParentheses := (Msg <> '') ;
           if AddParentheses then
              Msg := Msg + ' (' ;
           Msg := Msg + IntToStr(Percentage) + '%' ;
           if AddParentheses then
              Msg := Msg + ')' ;
        end ;
        ProgressForm.Caption := Msg ;

        ProgressForm.Bar.Position := Percentage ;
     end
     else
        Percentage := 0 ;

     if Percentage = 100 then begin
        Sleep(ProgressForm.Delay) ;
        ProgressForm.Reset ;
     end ;

     Result := cbrCONTINUE ;
end ;

procedure TProgressForm.Reset ;
begin
     Hide ;
     TotalRecords := 0 ;
     CancelDetected := False ;
     Height := OriginalFormHeight ;
     btnCancel.Top := OriginalButtonTop ;
end ;

procedure TProgressForm.btnCancelClick(Sender: TObject);
begin
     CancelDetected := True ;
end;

procedure Register;
begin
  RegisterComponents('GLAD: Database', [TGLProgress]);
end;

end.
