unit gleaster;

interface

uses
  {$IFDEF WIN32}
  Windows, 
  {$ELSE}
  WinTypes, WinProcs, 
  {$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TGLEasterEgg = class(TComponent)
  private
     FCurrentKey : integer ;       { storage location only... not published }
     FNotches : integer ;          { storage location only... not published }
     FEnabled : boolean ;
     FModifiers : TShiftState ;
     FOldOnKeyDown : TKeyEvent ;
     FOnFirstSuccess : TNotifyEvent ;
     FOnRepeatedSuccess : TNotifyEvent ;
     FPassword : string ;
     FReps : integer ;
     procedure SetPassword(s : string) ;
     procedure TestKeyPress(Sender: TObject; var Key: Word; Shift: TShiftState);
  public
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
  published
     property Enabled : boolean read FEnabled write FEnabled default True ;
     property Modifiers : TShiftState read FModifiers write FModifiers default [ssAlt] ;
     property OnFirstSuccess : TNotifyEvent read FOnFirstSuccess write FOnFirstSuccess ;
     property OnRepeatedSuccess : TNotifyEvent read FOnRepeatedSuccess write FOnRepeatedSuccess ;
     property Password : string read FPassword write SetPassword ;
     property Repetitions : integer read FReps write FReps default 0 ;
  end;

procedure Register;

implementation

constructor TGLEasterEgg.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FCurrentKey := 1 ;
     FEnabled := True ;
     FModifiers := [ssAlt] ;
     FNotches := 0 ;
     if not (csDesigning in ComponentState) then begin
        TForm(Owner).KeyPreview := True ;
        FOldOnKeyDown := TForm(Owner).OnKeyDown ;
        TForm(Owner).OnKeyDown := TestKeyPress ;
     end ;
end ;

destructor TGLEasterEgg.Destroy ;
begin
     if Owner <> nil then
        TForm(Owner).OnKeyDown := FOldOnKeyDown ;
     inherited Destroy ;
end ;

procedure TGLEasterEgg.SetPassword(s : string) ;
begin
     FPassword := UpperCase(s) ;
end ;

procedure TGLEasterEgg.TestKeyPress(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
     if FEnabled and (Shift * FModifiers = FModifiers) and
              (not (Key in [VK_SHIFT, VK_CONTROL, VK_MENU,
                            VK_LBUTTON, VK_MBUTTON, VK_RBUTTON])) then begin
        { force character to upper-case if not already }
        if Key > 96 then
           Key := Key - 32 ;

        { do we have a match at the current position in the password? }
        if Chr(Key) = Copy(FPassword, FCurrentKey, 1) then
           Inc(FCurrentKey)
        else
           FCurrentKey := 1 ;   { whoops! start all over again... }

        { have they typed in the entire key string? }
        if FCurrentKey > Length(FPassword) then begin
           Inc(FNotches) ;
           FCurrentKey := 1 ;    { start all over again }
           if FNotches = FReps then begin
              FNotches := 0 ;    { start all over again, but you know that if they got this far, they'll be back! }
              if Assigned(FOnRepeatedSuccess) then
                 FOnRepeatedSuccess(self)
           end
           else if Assigned(FOnFirstSuccess) then
              FOnFirstSuccess(self) ;
           (* at this point I must interject that, sans an OnPassword
              event handler, this component is incredibly useless! *)
        end ;
     end
     else if (Key <> 18) then
        FCurrentKey := 1 ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Misc.', [TGLEasterEgg]);
end;

end.
