unit ent_tab ;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes, WinProcs,
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TGLEnterAsTab = class(TComponent)
  private
     FEnabled : boolean ;
     FOldOnKeyDown : TKeyEvent ;
     procedure TestForEnter(Sender: TObject; var Key: Word; Shift: TShiftState);
  public
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
  published
     property Enabled : boolean read FEnabled write FEnabled default True ;
  end;

procedure Register;

implementation

constructor TGLEnterAsTab.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FEnabled := True ;
{$IFDEF SHOW_COPYRIGHT}
     ShowCopyright(self,True) ;
{$ENDIF}
     if not (csDesigning in ComponentState) then begin
        TForm(Owner).KeyPreview := True ;
        FOldOnKeyDown := TForm(Owner).OnKeyDown ;
        TForm(Owner).OnKeyDown := TestForEnter ;
     end ;
end ;

destructor TGLEnterAsTab.Destroy ;
begin
     if Owner <> nil then
        TForm(Owner).OnKeyDown := FOldOnKeyDown ;
     inherited Destroy ;
end ;

procedure TGLEnterAsTab.TestForEnter(Sender: TObject; var Key: Word;
   Shift: TShiftState);
var
     Dummy : TMsg ;
begin
     if (Key = 13) and FEnabled then begin
        Key := 0;
        { the following statement is to get rid of the beeping that
          Windows gives us in this situation.  For whatever reason,
          it sees the Enter keypress as being an invalid event. }
        PeekMessage(Dummy, TForm(Owner).Handle, WM_KEYFIRST, WM_KEYLAST, PM_REMOVE) ;
        if ssShift in Shift then
           TForm(Owner).Perform(WM_NEXTDLGCTL, 1, 0)    // backward
        else
           TForm(Owner).Perform(WM_NEXTDLGCTL, 0, 0);   // forward
     end
     else if Assigned(FOldOnKeyDown) then
        FOldOnKeyDown(Sender, Key, Shift) ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Interface', [TGLEnterAsTab]);
end;

end.
