unit blabel ;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,
  ExtCtrls { for TTimer -- added manually } ;

type
  TGLBlinkLabel = class(TLabel)
  private
    FBlinkColor : TColor ;
    FOldFontColor : TColor ;
    FOnBlink : TNotifyEvent ;
    FTimer : TTimer ;
    function GetBlinking : boolean ;
    function GetBlinkInterval : integer ;
    procedure SetBlinkColor(c : TColor) ;
    procedure SetBlinking(b : boolean) ;
    procedure SetBlinkInterval(i : integer) ;
    procedure Blinkie(Sender : TObject) ;
  public
    constructor Create(AOwner : TComponent) ; override ;
    destructor Destroy ; override ;
  published
    property BlinkColor : TColor read FBlinkColor write SetBlinkColor default clRed ;
    property Blinking : boolean read GetBlinking write SetBlinking default false ;
    property BlinkInterval : integer read GetBlinkInterval write SetBlinkInterval default 1000 ;
    property OnBlink : TNotifyEvent read FOnBlink write FOnBlink ;
  end;

procedure Register;

implementation

constructor TGLBlinkLabel.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FBlinkColor := clRed ;
     FOldFontColor := Font.Color ;
     FTimer := TTimer.Create(self) ;
     FTimer.Enabled := False ;
     FTimer.OnTimer := Blinkie ;
{$IFDEF SHOW_COPYRIGHT}
     ShowCopyright(self,True) ;
{$ENDIF}
end ;

destructor TGLBlinkLabel.Destroy ;
begin
     FTimer.Free ;
     inherited Destroy ;
end ;

procedure TGLBlinkLabel.SetBlinkColor(c : TColor) ;
begin
     if c <> Font.Color then begin
        FBlinkColor := c ;
        { next piece of logic prevents original Font.Color from being lost forever! }
        if Blinking then
           Font.Color := FOldFontColor ;
     end       
     else if csDesigning in ComponentState then
        MessageDlg('This will have no effect!', mtInformation, [mbOK], 0) ;
end ;

function TGLBlinkLabel.GetBlinking : boolean ;
begin
     Result := FTimer.Enabled ;
end ;

procedure TGLBlinkLabel.SetBlinking(b : boolean) ;
begin
     FTimer.Enabled := b ;
     if not b then
        Font.Color := FOldFontColor ;
end ;

function TGLBlinkLabel.GetBlinkInterval : integer ;
begin
     Result := FTimer.Interval ;
end ;

procedure TGLBlinkLabel.SetBlinkInterval(i : integer) ;
begin
     FTimer.Interval := i ;
end ;

procedure TGLBlinkLabel.Blinkie(Sender : TObject) ;
begin
     if Font.Color = FBlinkColor then
        Font.Color := FOldFontColor
     else begin
        FOldFontColor := Font.Color ;
        Font.Color := FBlinkColor ;
     end ;
     if Assigned(FOnBlink) then FOnBlink(self) ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Interface', [TGLBlinkLabel]);
end;

end.
