unit TBImageIndexEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, DsgnIntf, Buttons, imglist ;

type
  TGLToolButtonImageIndexEditor = class(TIntegerProperty)
     function GetAttributes : TPropertyAttributes ; override ;
     procedure Edit ; override ;
  end ;

  TGLToolButtonImageIndexEditorForm = class(TForm)
    ListBox: TListBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure ListBoxMeasureItem(Control: TWinControl; Index: Integer;
          var Height: Integer);
    procedure ListBoxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure ListBoxDblClick(Sender: TObject);
  public
    NormalImages : TCustomImageList ;
    HotImages : TCustomImageList ;
    DisabledImages : TCustomImageList ;
  end;

procedure Register ;

implementation

{$R *.DFM}

function TGLToolButtonImageIndexEditor.GetAttributes : TPropertyAttributes ;
begin
     Result := inherited GetAttributes + [paDialog]
end ;

procedure TGLToolButtonImageIndexEditor.Edit ;
var
   f : TGLToolButtonImageIndexEditorForm ;
   x : integer ;
begin
    with GetComponent(0) as TToolButton do
       with Parent as TToolBar do
          if (Images <> nil) and (Images.Count > 0) then begin
             f := TGLToolButtonImageIndexEditorForm.Create(nil) ;
             try
                // transfer imagelist properties from toolbar to dialog
                f.NormalImages := TImageList(Images) ;
                if (HotImages <> nil) and (HotImages.Count > 0) then
                   f.HotImages := HotImages ;
                if (DisabledImages <> nil) and (DisabledImages.Count > 0) then
                   f.DisabledImages := DisabledImages ;

                f.ListBox.Items.BeginUpdate ;
                for x := 0 to Images.Count - 1 do
                   f.ListBox.Items.Add('') ;
                f.ListBox.Items.EndUpdate ;
                f.ListBox.ItemIndex := GetOrdValue ;
                if f.ShowModal = mrOK then
                   SetOrdValue(f.ListBox.ItemIndex) ;
             finally
                f.Release ;
             end ;
          end ;
end ;

procedure TGLToolButtonImageIndexEditorForm.ListBoxMeasureItem(Control: TWinControl;
  Index: Integer; var Height: Integer);
var
   temp : TBitmap ;
begin
     temp := TBitmap.Create ;
     NormalImages.GetBitmap(Index, temp) ;
     Height := temp.Height + 4 ;
     temp.Free ;
end;

procedure TGLToolButtonImageIndexEditorForm.ListBoxDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
   temp : TBitmap ;
   tempPos : integer ;
begin
     with Control as TListBox do begin
        Canvas.FillRect(Rect) ;
        temp := TBitmap.Create ;
        NormalImages.GetBitmap(Index, temp) ;
        Canvas.Draw(Rect.Left + 1, Rect.Top + 1, temp) ;
        tempPos := Rect.Left + temp.Width + 1 ;
        if (HotImages <> nil) and (HotImages.Count > Index) then begin
           HotImages.GetBitmap(Index, temp) ;
           Canvas.Draw(tempPos, Rect.Top + 1, temp) ;
           Inc(tempPos, temp.Width + 1) ;
        end ;
        if (DisabledImages <> nil) and (DisabledImages.Count > Index) then begin
           DisabledImages.GetBitmap(Index, temp) ;
           Canvas.Draw(tempPos, Rect.Top + 1, temp) ;
        end ;
        temp.Free ;
     end ;
end;

procedure TGLToolButtonImageIndexEditorForm.ListBoxDblClick(Sender: TObject);
begin
     ModalResult := mrOK ;
end;

procedure Register ;
begin
     RegisterPropertyEditor(TypeInfo(integer),
        TToolButton,
        'ImageIndex',
        TGLToolButtonImageIndexEditor)
end ;

end.
