unit valgrid;

interface

uses
{$IFDEF WIN32}
  Windows, 
{$ELSE}
  WinTypes, WinProcs, 
{$ENDIF}
Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids;

type
  TGLValidateGrid = class ;

  TGridValidateEvent = procedure (Grid : TGLValidateGrid ; Col, Row: Longint;
                                  Data : string ; var DataOK : Boolean) of object;

  TGLValidateGrid = class(TStringGrid)
  private
     FEditing : boolean ;
     FOnValidate : TGridValidateEvent ;
     FOldData : string ;
     function DoValidate : boolean ;
  protected
     function GetEditText(ACol, ARow: Longint) : string ; override ;
     procedure KeyPress(var Key: Char); override ;
     function SelectCell(Col, Row: Longint) : boolean ; override ;
  public
     constructor Create(AOwner : TComponent) ; override ;
  published
     property OnValidate : TGridValidateEvent read FOnValidate
                                              write FOnValidate ;
  end;

procedure Register;

implementation

constructor TGLValidateGrid.Create(AOwner : TComponent) ;
begin
{$IFDEF WIN32}
     inherited ;
{$ELSE}
     inherited Create(AOwner) ;
{$ENDIF}
     Options := Options + [goEditing] ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLValidateGrid 1.0 - Copyright  1998 Greg Lief' + #13 +
                   'This component is part of the G.L.A.D. collection' + #13 +
                   'To remove this message and receive the source code, ' + #13 +
                   'register at http://www.greglief.com/delphi.shtml',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

function TGLValidateGrid.GetEditText(ACol, ARow: Longint) : string ;
begin
     FEditing := True ;
     FOldData := Cells[ACol, ARow] ;
     Result := inherited GetEditText(ACol, ARow) ;  { in case there is an OnGetEditText event }
end;

procedure TGLValidateGrid.KeyPress(var Key: Char);
begin
     if (Key = #13) and FEditing and DoValidate then
   {$IFDEF WIN32}
        inherited
   {$ELSE}
        inherited KeyPress(Key)
   {$ENDIF}
     else if Key = #27 then begin
        Cells[Col, Row] := FOldData ;
        EditorMode := False ;
   {$IFDEF WIN32}
        inherited ;
   {$ELSE}
        inherited KeyPress(Key) ;
   {$ENDIF}
     end ;
end;

function TGLValidateGrid.SelectCell(Col, Row: Longint) : boolean ;
begin
     Result := True ;
     if FEditing then
        if DoValidate then
           Result := inherited SelectCell(Col, Row)
        else
           Result := False ;
end;

function TGLValidateGrid.DoValidate : boolean ;
begin
     Result := True ;
     if Assigned(FOnValidate) then begin
        Result := False ;
        FOnValidate(self, Col, Row, Cells[Col, Row], Result) ;
     end ;
     if Result then
        FEditing := False ;
end ;

procedure Register;
begin
  RegisterComponents('Greg Lief', [TGLValidateGrid]);
end;

end.
