unit timeout;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinTypes, WinProcs,
  {$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls { for TTimer } ;

type
  TGLTimeout = class(TComponent)
  private
     FOldOnMessage : TMessageEvent ;
     FOnTimeout : TNotifyEvent ;
     FTimer : TTimer ;
     FMinutesInactive : integer ;
     FMinutes : integer ;
     function  GetEnabled : boolean ;
     procedure SetEnabled(b : boolean) ;
     procedure TimerEvent(Sender : TObject) ;
     procedure HandleMessages(var Msg: TMsg; var Handled: Boolean) ;
  public
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
     procedure Start ;
     procedure Stop ;
  published
     property Enabled : boolean read GetEnabled write SetEnabled default True ;
     property Minutes : integer read FMinutes write FMinutes default 5 ;
     property OnTimeout : TNotifyEvent read FOnTimeout write FOnTimeout ;
  end;

procedure Register;

implementation

constructor TGLTimeout.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FTimer := TTimer.Create(self) ;
     FTimer.Interval := 60000 ;
     FTimer.OnTimer := TimerEvent ;
     FMinutes := 5 ;
     FMinutesInactive := 0 ;
     if not (csDesigning in ComponentState) then begin
        FOldOnMessage := Application.OnMessage ;
        Application.OnMessage := HandleMessages ;
     end
{$IFDEF SHOW_COPYRIGHT}
     else
        MessageDlg('TGLTimeout 1.0 - Copyright  1998 Greg Lief' + #13 +
                   'This component is part of the G.L.A.D. collection' + #13 +
                   'To remove this message and receive the source code, ' + #13 +
                   'register at http://www.greglief.com/delphi.shtml',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

destructor TGLTimeout.Destroy ;
begin
     Application.OnMessage := FOldOnMessage ;
     Stop ;
     FTimer.Free ;
     inherited Destroy ;
end ;

function TGLTimeout.GetEnabled : boolean ;
begin
     Result := FTimer.Enabled ;
end ;

procedure TGLTimeout.SetEnabled(b : boolean) ;
begin
     FTimer.Enabled := b ;
     if not b then
        FMinutesInactive := 0 ;
end ;

procedure TGLTimeout.HandleMessages(var Msg: TMsg; var Handled: Boolean) ;
begin
     case Msg.Message of
        WM_LBUTTONDBLCLK, WM_MBUTTONDBLCLK, WM_RBUTTONDBLCLK,
        WM_LBUTTONDOWN, WM_MBUTTONDOWN, WM_RBUTTONDOWN,
        WM_NCLBUTTONDOWN, WM_NCMBUTTONDOWN, WM_NCRBUTTONDOWN,
        WM_DEADCHAR, WM_KEYDOWN, WM_SYSCHAR, WM_SYSKEYDOWN,
        {$IFDEF WIN32}
        WM_HOTKEY,
        {$ENDIF}
        WM_SYSDEADCHAR :
           begin
              Stop ;
              Start ;
           end ;
     end ;
end ;

procedure TGLTimeout.Start ;
begin
     Enabled := True ;
end ;

procedure TGLTimeout.Stop ;
begin
     Enabled := False ;
end ;

procedure TGLTimeout.TimerEvent(Sender : TObject) ;
begin
     if not (csDesigning in ComponentState) then begin
        FMinutesInactive := FMinutesInactive + 1 ;
        if (FMinutesInactive = FMinutes) then
           if Assigned(FOnTimeout) then begin
              FOnTimeout(self) ;
              FMinutesInactive := 0
           end
           else
              Application.Terminate ;
        end ;
end ;

procedure Register;
begin
  RegisterComponents('Greg Lief', [TGLTimeout]);
end;

end.
