unit Tblform1;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBTables, Buttons, DB,
  DBIProcs, DBITypes, DBConsts { added manually for RecordNumber method } ;

type
  TTableForm = class(TForm)
    Tables: TListBox;
    lblDatabaseName: TLabel;
    lblTableName: TLabel;
    cbExclusive: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    lblRecordNo: TLabel;
    lbIndexes: TListBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    cbUnique: TCheckBox;
    cbDescending: TCheckBox;
    cbExpression: TCheckBox;
    cbCaseInsensitive: TCheckBox;
    Label9: TLabel;
    lblExpression: TLabel;
    lblFields: TLabel;
    lbFields: TListBox;
    cbRequired: TCheckBox;
    Label10: TLabel;
    lblDataType: TLabel;
    Label11: TLabel;
    lblSize: TLabel;
    BitBtn1: TBitBtn;
    Label12: TLabel;
    lblOwner: TLabel;
    procedure TablesClick(Sender: TObject);
    procedure lbIndexesClick(Sender: TObject);
    procedure lbFieldsClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    procedure ClearIndexInfo ;
  end;

var
  TableForm: TTableForm;

implementation

function RecNo(t : TTable) : longint ; forward ;

{$R *.DFM}

procedure TTableForm.TablesClick(Sender: TObject);
var
   x : integer ;
   s : string ;
   r : integer ;
const
   PRIMARY = '<primary>' ;
begin
     with Tables.Items.Objects[Tables.ItemIndex] as TTable do begin
        lblDatabaseName.Caption := DatabaseName ;
        lblTableName.Caption := TableName ;
        lblOwner.Caption := Owner.Name ;

        lbFields.Clear ;
        for x := 0 to FieldCount - 1 do
           lbFields.Items.AddObject(FieldDefs[x].Name, FieldDefs[x]) ;
        lbFields.ItemIndex := 0 ;
        lbFieldsClick(lbFields) ; { update field information }

        lbIndexes.Clear ;
        IndexDefs.Update ;
        for x := 0 to IndexDefs.Count - 1 do begin
           s := IndexDefs[x].Name ;
           if (s = '') then
              if IndexName = '' then
                 s := PRIMARY + '*'
              else
                 s := PRIMARY
           else if s = IndexName then
              s := s + '*' ;
           lbIndexes.Items.AddObject(s, IndexDefs[x]) ;
        end ;
        if IndexDefs.Count > 0 then begin
           lbIndexes.ItemIndex := 0 ;
           lbIndexesClick(lbIndexes) ;   { to refresh index information }
           lbIndexes.Enabled := True ;
        end
        else begin
           lbIndexes.Enabled := False ;
           lbIndexes.Items.Add('<none>') ;
           ClearIndexInfo ;
        end ;

        r := RecNo(Tables.Items.Objects[Tables.ItemIndex] as TTable) ;
        lblRecordNo.Caption := IntToStr(r) + ' of ' + IntToStr(RecordCount);
        cbExclusive.Checked := Exclusive ;
     end ;
end;

procedure TTableForm.lbIndexesClick(Sender: TObject);
begin
     with lbIndexes.Items.Objects[lbIndexes.ItemIndex] as TIndexDef do begin
        if Expression = '' then
           lblExpression.Caption := '<none>'
        else
           lblExpression.Caption := Expression ;
        if Fields = '' then
           lblFields.Caption := '<none>'
        else
           lblFields.Caption := Fields ;
        cbUnique.Checked := ixUnique in Options ;
        cbDescending.Checked := ixDescending in Options ;
        cbExpression.Checked := ixExpression in Options ;
        cbCaseInsensitive.Checked := ixCaseInsensitive in Options ;
     end ;
end;

procedure TTableForm.ClearIndexInfo ;
begin
     cbUnique.Checked := False ;
     cbDescending.Checked := False ;
     cbExpression.Checked := False ;
     cbCaseInsensitive.Checked := False ;
     lblExpression.Caption := '<none>' ;
     lblFields.Caption := '<none>'
end ;

procedure TTableForm.lbFieldsClick(Sender: TObject);
const
   DataTypes : array[TFieldType] of string = ('Unknown', 'String', 'Smallint',
               'Integer', 'Word', 'Boolean', 'Float', 'Currency', 'BCD', 'Date',
               'Time', 'DateTime', 'Bytes', 'VarBytes', 'Blob',
               'Memo', 'Graphic') ;
begin
     with lbFields.Items.Objects[lbFields.ItemIndex] as TFieldDef do begin
        lblSize.Caption := IntToStr(Size) ;
        lblDataType.Caption := DataTypes[DataType] ;
        cbRequired.Checked := Required ;
     end ;
end;

procedure TTableForm.BitBtn1Click(Sender: TObject);
begin
     Close ;
end;

function RecNo(t : TTable) : Longint ;
var
    cursorprops : curprops;
    recordprops : recprops;
begin
    Result:=0;
    with t do begin
       if State = dsInactive then
          DBError(SDataSetClosed);
       Check(DbiGetCursorProps(Handle,CursorProps));
       UpdateCursorPos;
       Check(DbiGetRecord(Handle,dbiNOLOCK,nil,@recordprops));
       case cursorprops.iseqnums of
          0 : Result := recordprops.iPhyRecNum;
          1 : Result := recordprops.iSeqNum;
       end;
    end;
end;

end.
