unit hlb ;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinTypes, WinProcs, Menus,
  {$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls ;

type
  TGLHighlightListBox = class(TCustomListBox)
  private
    FCaseSensitive : boolean ;
    FHighlightUnselFG : TColor ;
    FHighlightUnselBG : TColor ;
    FHighlightSelFG : TColor ;
    FHighlightSelBG : TColor ;
    FHighlightText : string ;
    FTextLength : integer ;
    procedure SetHighlightUnselFG(c : TColor) ;
    procedure SetHighlightUnselBG(c : TColor) ;
    procedure SetHighlightSelFG(c : TColor) ;
    procedure SetHighlightSelBG(c : TColor) ;
    procedure SetHighlightText(s : string) ;
    procedure SetCaseSensitive(b : boolean) ;
  protected
    procedure DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState); override ;
  public
    constructor Create(AOwner : TComponent) ; override ;
  published
    property CaseSensitive : boolean read FCaseSensitive
             write SetCaseSensitive default False ;
    property HighlightUnselectedFG : TColor read FHighlightUnselFG
             write SetHighlightUnselFG default clBlack ;
    property HighlightUnselectedBG : TColor read FHighlightUnselBG
             write SetHighlightUnselBG default clYellow ;
    property HighlightSelectedFG : TColor read FHighlightSelFG
             write SetHighlightSelFG default clBlack ;
    property HighlightSelectedBG : TColor read FHighlightSelBG
             write SetHighlightSelBG default clYellow ;
    property HighlightText : string read FHighlightText write SetHighlightText ;
    property Align;
    property BorderStyle;
    property Color;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property ExtendedSelect;
    property Font;
    property IntegralHeight;
    property ItemHeight;
    property Items;
    property MultiSelect;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Sorted;
    property TabOrder;
    property TabStop;
    {$IFDEF WIN32}
    property TabWidth;
    {$ENDIF}
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    {$IFDEF WIN32}
    property OnStartDrag;
    {$ENDIF}
  end;

procedure Register;

implementation

constructor TGLHighlightListBox.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     Style := lbOwnerDrawFixed ;
     FHighlightUnselBG := clYellow ;
     FHighlightSelBG := clYellow ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLHighlightListBox 1.0 - Copyright  1998 Greg Lief' + #13 +
                   'This component is part of the G.L.A.D. collection' + #13 +
                   'To remove this message and receive the source code, ' + #13 +
                   'register at http://www.greglief.com/delphi.shtml',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

procedure TGLHighlightListBox.SetHighlightText(s : string) ;
begin
     FHighlightText := s ;
     FTextLength := Length(s) ;
     Refresh ;
end ;

procedure TGLHighlightListBox.SetHighlightUnselFG(c : TColor) ;
begin
     FHighlightUnselFG := c ;
     Refresh ;
end ;

procedure TGLHighlightListBox.SetHighlightUnselBG(c : TColor) ;
begin
     FHighlightUnselBG := c ;
     Refresh ;
end ;

procedure TGLHighlightListBox.SetHighlightSelFG(c : TColor) ;
begin
     FHighlightSelFG := c ;
     Refresh ;
end ;

procedure TGLHighlightListBox.SetHighlightSelBG(c : TColor) ;
begin
     FHighlightSelBG := c ;
     Refresh ;
end ;

procedure TGLHighlightListBox.SetCaseSensitive(b : boolean) ;
begin
     FCaseSensitive := b ;
     Refresh ;
end ;

procedure TGLHighlightListBox.DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
   Location : integer ;
   s : string ;
   PrintText : string;
   CurrentX : integer ;
   OldBrushColor : TColor ;
   OldFontColor : TColor ;
begin
     Canvas.FillRect(Rect) ;
     if FCaseSensitive then
        Location := Pos(HighlightText, Items[Index])
     else
        Location := Pos(UpperCase(HighlightText), UpperCase(Items[Index])) ;
     if Location > 0 then begin
        s := Items[Index] ;
        CurrentX := 0 ;
        while Location > 0 do begin
           { draw the text preceding highlight text }
           PrintText := Copy(s, 1, Location - 1) ;
           Canvas.TextOut(CurrentX, Rect.Top, PrintText) ;
           Inc(CurrentX, Canvas.TextWidth(PrintText)) ;
           { now draw the highlight text }
           OldBrushColor := Canvas.Brush.Color ;
           OldFontColor := Canvas.Font.Color ;
           if odSelected in State then begin
              Canvas.Font.Color := FHighlightSelFG ;
              Canvas.Brush.Color := FHighlightSelBG ;
           end
           else begin
              Canvas.Font.Color := FHighlightUnselFG ;
              Canvas.Brush.Color := FHighlightUnselBG ;
           end ;
           s := Copy(s, Location, Length(s)) ;
           PrintText := Copy(s, 1, FTextLength) ;
           Canvas.TextOut(CurrentX, Rect.Top, PrintText) ;
           Inc(CurrentX, Canvas.TextWidth(PrintText)) ;
           s := Copy(s, FTextLength + 1, Length(s)) ;
           Canvas.Font.Color := OldFontColor ;
           Canvas.Brush.Color := OldBrushColor ;
           if FCaseSensitive then
              Location := Pos(UpperCase(HighlightText), UpperCase(s))
           else
              Location := Pos(HighlightText, s) ;
        end ;
        if s <> '' then
           Canvas.TextOut(CurrentX, Rect.Top, s) ;
     end
     else
        Canvas.TextOut(Rect.Left, Rect.Top, Items[Index]) ;
end;

procedure Register;
begin
  RegisterComponents('Greg Lief', [TGLHighlightListBox]);
end;

end.
