unit glrunone ;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TGLRunOnce = class(TComponent)
  private
     FAlreadyRunning : boolean ;
     FAlwaysTerminate : boolean ;
     FErrorMsg : string ;
     FShowErrorMsg : boolean ; 
  protected
     procedure Loaded ; override ;
  public 
     property AlreadyRunning : boolean read FAlreadyRunning ;
     constructor Create(AOwner : TComponent) ; override ;
  published
     property AlwaysTerminate : boolean read FAlwaysTerminate write FAlwaysTerminate default True ;
     property ErrorMessage : string read FErrorMsg write FErrorMsg ;
     property ShowErrorMessage : boolean read FShowErrorMsg write FShowErrorMsg default True ;
  end;

procedure Register;

implementation

constructor TGLRunOnce.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FAlwaysTerminate := True ;
     FErrorMsg := 'This application is already running!' ;
     FShowErrorMsg := True ;
end ;

procedure TGLRunOnce.Loaded ;
begin
     inherited Loaded ;
     if (not (csDesigning in ComponentState)) then begin
        FAlreadyRunning := (HPrevInst <> 0) ;
        if FAlreadyRunning and FAlwaysTerminate then begin
           if FShowErrorMsg then
              MessageDlg(FErrorMsg, mtError, [mbOK], 0) ;
           { reduce flickering }
           with Owner as TForm do begin
              Height := 0 ;
              Width := 0 ;
              Top := Screen.Height + 1 ;
              Left := Screen.Width + 1 ;
           end ;
           Application.Terminate ;
        end ;
     end ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Misc.', [TGLRunOnce]);
end;

end.
