unit gldfiles ;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ShellAPI ;

type
  TGLDropFilesEvent = procedure (FileNames : TStringList) of object ;

  TGLDropFiles = class(TComponent)
  private
     FOldOnMessage : TMessageEvent ;
     FOnDropFiles : TGLDropFilesEvent ;
     FFileNames : TStringList ;
     procedure HandleMessages(var Msg: TMsg; var Handled: Boolean) ;
  public
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
     property FileNames : TStringList read FFileNames ;
  published
     property OnDropFiles : TGLDropFilesEvent read FOnDropFiles write FOnDropFiles ;
  end;

procedure Register;

implementation

constructor TGLDropFiles.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FFileNames := TStringList.Create ;
     if not (csDesigning in ComponentState) then begin
        DragAcceptFiles((Owner as TForm).Handle, True);
        FOldOnMessage := Application.OnMessage ;
        Application.OnMessage := HandleMessages ;
     end
{$IFDEF SHOW_COPYRIGHT}
     else
        MessageDlg('TGLDropFiles 1.0 - Copyright  1998 Greg Lief',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

destructor TGLDropFiles.Destroy ;
begin
     if (Owner <> nil) and (not (csDesigning in ComponentState) ) then
        DragAcceptFiles((Owner as TForm).Handle, False);
     Application.OnMessage := FOldOnMessage ;
     FFileNames.Free ;
     inherited Destroy ;
end ;


procedure TGLDropFiles.HandleMessages(var Msg: TMsg; var Handled: Boolean) ;
var
   sFileName : string ;
   NumFiles : integer ;
   x : integer ;
const
   BUFF_SIZE = 512 ;
begin
     if Msg.Message = WM_DROPFILES then begin
        FFileNames.Clear ;
        NumFiles := DragQueryFile(Msg.WParam, $FFFF, nil, 0) ;
        for x := 0 to NumFiles - 1 do begin
           DragQueryFile(Msg.WParam, x, @sFileName[1], 255);
           Byte(sFileName[0]) := StrLen(@sFileName[1]) ;
           FFileNames.Add( sFileName ) ;
        end ;
        DragFinish(Msg.WParam);
        if Assigned(FOnDropFiles) then
           FOnDropFiles(FileNames) ;
    end ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Misc.', [TGLDropFiles]);
end;

end.
