unit dmpqry ;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinTypes, WinProcs,
  {$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, DBTables;

type
  TGLDumpQuery = class(TQuery)
  private
     FAutoCreate : boolean ;
     FTable : TTable ;
     FOldAfterOpen : TDataSetNotifyEvent ;
     function GetDestDatabaseName : TFileName ;
     procedure SetDestDatabaseName(s : TFileName) ;
     function GetDestTableName : string ;
     procedure SetDestTableName(s : string) ;
     function GetDestTableType : TTableType ;
     procedure SetDestTableType(s : TTableType) ;
     procedure NewAfterOpen(DataSet: TDataSet) ;
  protected
     procedure Loaded ; override ;
  public
     procedure CreateAnswerTable ;
     property DestTable : TTable read FTable ;
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
  published
     property AutoCreateAnswerTable : boolean read FAutoCreate write FAutoCreate default True ;
     property DestDatabaseName : TFileName read GetDestDatabaseName write SetDestDatabaseName ;
     property DestTableName : string read GetDestTableName write SetDestTableName ;
     property DestTableType : TTableType read GetDestTableType write SetDestTableType default ttDefault ;
  end;

procedure Register;

implementation

constructor TGLDumpQuery.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLDumpQuery(1.0) - Copyright  1998 Greg Lief' + #13 +
                   'This component is part of the G.L.A.D. collection' + #13 +
                   'To remove this message and receive the source code, ' + #13 +
                   'register at http://www.greglief.com/delphi.shtml',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
     FTable := TTable.Create(self) ;
     FAutoCreate := True ;
end ;

procedure TGLDumpQuery.Loaded ;
begin
     inherited Loaded ;
     FOldAfterOpen := AfterOpen ;
     AfterOpen := NewAfterOpen ;
end ;

destructor TGLDumpQuery.Destroy ;
begin
     FTable.Free ;
     inherited Destroy ;
end ;

procedure TGLDumpQuery.NewAfterOpen(DataSet: TDataSet) ;
begin
     { No need to continue if destination table name not specified! }
     if FAutoCreate and (DestTableName <> '') then
        CreateAnswerTable ;
     if Assigned(FOldAfterOpen) then FOldAfterOpen(self) ;
end ;

procedure TGLDumpQuery.CreateAnswerTable ;
var
   b : TBatchMove ;
begin
     b := TBatchMove.Create(self) ;
     try
        { if no DatabaseName was provided for the destination table,
          use the same one as the TQuery }
        if DestDatabaseName = '' then
           DestDatabaseName := DatabaseName ;
        b.Mode := batCopy ;
        b.Source := self ;
        b.Destination := FTable ;
        b.Execute ;
        if Assigned(FOldAfterOpen) then
           FOldAfterOpen(self) ;
     finally
        b.Free ;
     end ;
end ;

function TGLDumpQuery.GetDestDatabaseName : TFileName ;
begin
     Result := FTable.DatabaseName ;
end ;

procedure TGLDumpQuery.SetDestDatabaseName(s : TFileName) ;
begin
     FTable.DatabaseName := s ;
end ;

function TGLDumpQuery.GetDestTableName : string ;
begin
     Result := FTable.TableName ;
end ;

procedure TGLDumpQuery.SetDestTableName(s : string) ;
begin
     FTable.TableName := s ;
end ;

function TGLDumpQuery.GetDestTableType : TTableType ;
begin
     Result := FTable.TableType ;
end ;

procedure TGLDumpQuery.SetDestTableType(s : TTableType) ;
begin
     FTable.TableType := s ;
end ;

procedure Register;
begin
  RegisterComponents('Greg Lief', [TGLDumpQuery]);
end;

end.
