unit ClrCombo ;

interface

uses
  WinProcs, WinTypes, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TGLColorComboBox = class(TCustomComboBox)
  private
     function GetSelectedColor : TColor ;
     procedure SetSelectedColor(c : TColor) ;
  protected
     procedure CreateWnd ; override ;
     procedure DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState); override ;
  public
     constructor Create(AOwner : TComponent) ; override ;
  published
     property Color;
     property Ctl3D;
     property DragCursor;
     property DragMode;
     property Enabled;
     property Font ;
     property ParentColor;
     property ParentCtl3D;
     property ParentFont;
     property ParentShowHint;
     property SelectedColor : TColor read GetSelectedColor write SetSelectedColor ;
     property ShowHint;
     property TabOrder;
     property TabStop;
     property Visible;
     property OnClick;
     property OnDblClick;
     property OnDragDrop;
     property OnDragOver;
     property OnEndDrag;
     property OnEnter;
     property OnExit;
     property OnKeyDown;
     property OnKeyPress;
     property OnKeyUp;
     property OnMouseDown;
     property OnMouseMove;
     property OnMouseUp;
     {$IFDEF WIN32}
     property OnStartDrag;
     {$ENDIF}
  end;

const
     Colors : array[0..15] of TColor = (clBlack, clMaroon, clGreen, clOlive, clNavy,
                                        clPurple, clTeal, clGray, clSilver, clRed,
                                        clLime, clYellow, clBlue, clAqua, clWhite,
                                        clFuchsia) ;

procedure Register;

implementation

constructor TGLColorComboBox.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     Style := csOwnerDrawFixed ;
end ;

procedure TGLColorComboBox.CreateWnd ;
var
   x : integer ;
begin
     inherited CreateWnd ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLColorComboBox (1.01) - Copyright  1998 Greg Lief' + #13 +
                   'This component is part of the G.L.A.D. collection' + #13 +
                   'To remove this message and receive the source code, ' + #13 +
                   'register at http://www.greglief.com/delphi.shtml',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
     for x := 0 to High(Colors) do
        Items.Add(Copy( ColorToString(Colors[x]), 3, 20) ) ;
     SetSelectedColor(clBlack) ;
end ;

procedure TGLColorComboBox.DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
   OldColor : TColor ;
begin
     Canvas.FillRect(Rect) ;
     OldColor := Canvas.Brush.Color ;
     Canvas.Brush.Color := Colors[Index] ;
     Canvas.Pen.Color := clBlack ;
     Canvas.Rectangle(Rect.Left + 2, Rect.Top + 2, Rect.Left + 25, Rect.Bottom - 2) ;
     Canvas.Brush.Color := OldColor ;
     Canvas.TextOut(Rect.Left + 30, Rect.Top, Items[Index]) ;
end ;

function TGLColorComboBox.GetSelectedColor : TColor ;
begin
     Result := Colors[ItemIndex] ;
end ;

procedure TGLColorComboBox.SetSelectedColor(c : TColor) ;
var
   x : integer ;
begin
     x := 0 ;
     while (x < High(Colors)) and (c <> Colors[x]) do
        Inc(x) ;
     if x < High(Colors) then
        ItemIndex := x ;
end ;

procedure Register;
begin
  RegisterComponents('Greg Lief', [TGLColorComboBox]);
end;

end.
