unit clonerec;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, DB ;

type
  TGLCloneRecord = class(TComponent)
  private
     FAutoPost : boolean ;
     FBeforePost : TDataSetNotifyEvent ;
     FDataSet : TDataSet ;
     FErrorMsg : string ;
     FFields : TStringList ;
     procedure SetDataSet(d : TDataSet) ;
     procedure SetFields(s : TStringList) ;
  protected
     procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
     property ErrorMessage : string read FErrorMsg ;
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
     function Execute : boolean ; virtual ;
  published
     property AutoPost : boolean read FAutoPost write FAutoPost default True ;
     property DataSet : TDataSet read FDataSet write SetDataSet ;
     property Fields : TStringList read FFields write SetFields ;
     property BeforePost : TDataSetNotifyEvent read FBeforePost
                                               write FBeforePost ;
  end;

procedure Register;

implementation

constructor TGLCloneRecord.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FAutoPost := True ;
     FFields := TStringList.Create ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLCloneRecord - Copyright  1998 Greg Lief' + #13 +
                   'This component is part of the G.L.A.D. collection' + #13 +
                   'To remove this message and receive the source code, ' + #13 +
                   'register at http://www.greglief.com/delphi.shtml',
                   mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

destructor TGLCloneRecord.Destroy ;
begin
     FFields.Free ;
     inherited Destroy ;
end ;

procedure TGLCloneRecord.SetDataSet(d : TDataSet) ;
var
   x : integer ;
begin
     if d <> FDataSet then begin
        FDataSet := d ;
        if [csDesigning,csLoading] * ComponentState = [csDesigning] then begin
           FFields.Clear ;
           if FDataSet <> nil then begin
              FDataSet.FieldDefs.Update ;
              for x := 0 to FDataSet.FieldDefs.Count - 1 do
                 FFields.Add(FDataSet.FieldDefs[x].Name) ;
           end ;
        end ;   
     end ;
end ;


procedure TGLCloneRecord.SetFields(s : TStringList) ;
var
   x : integer ;
begin
     if FDataSet <> nil then begin
        x := 0 ;
        FDataSet.FieldDefs.Update ;
        while (x < s.Count) and
              (FDataSet.FieldDefs.IndexOf(s[x]) <> -1) do
           Inc(x) ;
        if x = s.Count then
           FFields.Assign(s)
        else if csDesigning in ComponentState then
           MessageDlg('Field "' + s[x] + '" does not exist', mtError, [mbOK], 0) ;
     end ;
end ;

function TGLCloneRecord.Execute : boolean ;
var
   x : integer ;
   Buffer : TStringList ;
begin
     Result := True ;
     if (FDataSet <> nil) and (FDataSet.Active) then begin
        Buffer := TStringList.Create ;
        try
           { store values of fields in current record }
           for x := 0 to FFields.Count - 1 do
              Buffer.Add( FDataSet.FieldByName(FFields[x]).AsString ) ;

           { add the new record (duh) }
           FDataSet.Append ;

           { loop through buffer to initialize fields in new record }
           for x := 0 to FFields.Count - 1 do
              { local exception handler to trap key violation errors }
              try
                 FDataSet.FieldByName(FFields[x]).AsString := Buffer[x] ;
              except
                 FDataSet.FieldByName(FFields[x]).AsString := '' ;
              end ;

           { post new record if desired, checking first for BeforePost event }
           if FAutoPost then begin
              if Assigned(FBeforePost) then FBeforePost(FDataSet) ;
              try
                 FDataSet.Post ;
              except
                 on E : Exception do begin
                    Result := False ;
                    FErrorMsg := E.Message ;
                 end ;
              end ;
           end ;
        finally
           Buffer.Free ;
        end ;
     end ;
end ;

procedure TGLCloneRecord.Notification(AComponent: TComponent;
          Operation: TOperation);
begin
     if (Operation = opRemove) and (AComponent = FDataSet) then
        FDataSet := nil ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Database', [TGLCloneRecord]);
end;

end.
