unit fd_form;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB, Buttons, Menus ;

type
  TGLFieldSelectionDialog = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    UpButton: TBitBtn;
    DownButton: TBitBtn;
    PopupMenu1: TPopupMenu;
    InsertFields1: TMenuItem;
    InsertButton: TBitBtn;
    DeleteButton: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure UpButtonClick(Sender: TObject);
    procedure DownButtonClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure InsertFields1Click(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
  private
    procedure ListBoxClick(Sender: TObject);
    procedure InsertFields ;
    procedure RefreshButtons ;
  public
    DataSet : TDataSet ;
    ListBox : TListBox ;
    ValidDataTypes : set of TFieldType ;
  end;

implementation

{$R *.DFM}

procedure TGLFieldSelectionDialog.FormCreate(Sender: TObject);
begin
     ListBox := TListBox.Create(self) ;
     ListBox.Height := 160 ;
     ListBox.Align := alTop ;
     ListBox.Parent := self ;
     ListBox.OnClick := ListBoxClick ;
     ListBox.PopupMenu := PopupMenu1 ;
     DataSet := nil ;
     ValidDataTypes := [] ;   { a null set means that all data types are valid }
     ActiveControl := ListBox ;
end;

procedure TGLFieldSelectionDialog.ListBoxClick(Sender: TObject);
begin
     RefreshButtons ;
end ;

procedure TGLFieldSelectionDialog.RefreshButtons ;
begin
     UpButton.Enabled := (ListBox.ItemIndex > 0) ;
     DownButton.Enabled := (ListBox.ItemIndex < ListBox.Items.Count - 1) ;
     InsertButton.Enabled := (ListBox.Items.Count < DataSet.FieldCount) ;
     DeleteButton.Enabled := (ListBox.Items.Count > 0) ;
end ;

procedure TGLFieldSelectionDialog.UpButtonClick(Sender: TObject);
var
   s : string ;
   i : integer ;
begin
     with ListBox do begin
        s := Items[ItemIndex] ;
        i := ItemIndex ;
        Items.Delete(ItemIndex) ;
        Items.Insert(i - 1, s) ;
        ItemIndex := i - 1 ;
     end ;
     RefreshButtons ;
end;

procedure TGLFieldSelectionDialog.DownButtonClick(Sender: TObject);
var
   s : string ;
   i : integer ;
begin
     with ListBox do begin
        s := Items[ItemIndex] ;
        i := ItemIndex ;
        Items.Delete(ItemIndex) ;
        Items.Insert(i + 1, s) ;
        ItemIndex := i + 1 ;
        Click ;  { force enabling/disabling of up/down buttons }
     end ;
end;

procedure TGLFieldSelectionDialog.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     if Key = vk_Insert then begin
        Key := 0 ;
        InsertFields ;
     end ;
end;

procedure TGLFieldSelectionDialog.InsertFields ;
var
   f : TGLFieldSelectionDialog ;
   x : integer ;
   Pos : integer ;
   HadToOpen : boolean ;
begin
     f := TGLFieldSelectionDialog.Create(nil) ;
     f.UpButton.Visible := False ;
     f.DownButton.Visible := False ;
     f.OnKeyDown := nil ;
     f.Position := poDesigned ;
     f.Top := Top + 50 ;
     f.Left := Left + 50 ;
     f.Height := f.Height - 28 ;
     f.Caption := 'Insert Fields' ;
     f.ListBox.MultiSelect := True ;
     { load listbox with only those string fields which
       are NOT already present in the list }
     HadToOpen := (DataSet.FieldCount = 0) and (not DataSet.Active) ;
     if HadToOpen then
        DataSet.Open ;

     for x := 0 to DataSet.FieldCount - 1 do
        if ((ValidDataTypes = []) or
            (DataSet.Fields[x].DataType in ValidDataTypes)) and
            (ListBox.Items.IndexOf(DataSet.Fields[x].FieldName) = -1) then begin
           f.ListBox.Items.Add(DataSet.Fields[x].FieldName) ;
           f.ListBox.Selected[f.ListBox.Items.Count - 1] := True ;
        end ;

     if HadToOpen then
        DataSet.Close ;

     if f.ListBox.Items.Count = 0 then begin
        MessageDlg('No fields available for insertion', mtError, [mbOK], 0) ;
        f.Release ;
     end
     else
        try
           if (f.ShowModal = mrOK) and (f.ListBox.SelCount > 0) then begin
              Pos := 1 ;
              for x := 0 to f.ListBox.Items.Count - 1 do
                 if f.ListBox.Selected[x] then begin
                    ListBox.Items.Insert(ListBox.ItemIndex + Pos, f.ListBox.Items[x]) ;
                    Inc(Pos) ;
                 end ;
           end ;
        finally
           f.Release ;
        end ;
        
end;

procedure TGLFieldSelectionDialog.InsertFields1Click(Sender: TObject);
begin
     InsertFields ;
end;

procedure TGLFieldSelectionDialog.DeleteButtonClick(Sender: TObject);
var
   i : integer ;
begin
     with ListBox do begin
        i := ItemIndex ;
        Items.Delete(ItemIndex) ;
        if i = Items.Count then
           ItemIndex := Items.Count - 1
        else
           ItemIndex := i ;
        ListBoxClick(nil) ;
     end ;
end;

end.
