unit slabel ;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB;

type
  TGLStateLabel = class(TLabel)
  private
     FDataSource : TDataSource ;
     FPrevStateChange : TNotifyEvent ;
     procedure SetDataSource(d : TDataSource) ;
  protected
     procedure Notification(AComponent: TComponent; Operation: TOperation); override ;
  public
     constructor Create(AOwner : TComponent) ; override ;
     procedure RedrawLabel(Sender : TObject) ;
  published
     property DataSource : TDataSource read FDataSource
                                       write SetDataSource ;
  end;

procedure Register;

const
   aStates : array[TDataSetState] of string =
{$IFDEF VER100}   {D3 has 10 states }
      ('dsInactive', 'dsBrowse', 'dsEdit',
      'dsInsert', 'dsSetKey', 'dsCalcFields',
      'dsFilter', 'dsNewValue', 'dsOldValue', 'dsCurValue') ;
{$ENDIF}

{$IFDEF VER90}   { D2 has 9 states }
      ('dsInactive', 'dsBrowse', 'dsEdit',
      'dsInsert', 'dsSetKey', 'dsCalcFields',
      'dsUpdateNew', 'dsUpdateOld', 'dsFilter') ;
{$ENDIF}

{$IFDEF VER80}   { D1 has 6 states }
      ('dsInactive', 'dsBrowse', 'dsEdit',
      'dsInsert', 'dsSetKey', 'dsCalcFields') ;
{$ENDIF}

implementation

constructor TGLStateLabel.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLStateLabel 1.01 - Copyright  1998 Greg Lief' + #13 + 'This component is part of the G.L.A.D. collection' + #13 + 'To remove this message and receive the source code, ' + #13 + 'register at http://www.greglief.com/delphi.shtml',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

procedure TGLStateLabel.Notification(AComponent: TComponent;
          Operation: TOperation);
begin
     if (AComponent = FDataSource) and (Operation = opRemove) then
        FDataSource := nil ;
end ;

procedure TGLStateLabel.SetDataSource(d : TDataSource) ;
var
   t : TNotifyEvent ;
begin
     FDataSource := d ;
     t := FDataSource.OnStateChange ;
     if Assigned(t) then
        FPrevStateChange := FDataSource.OnStateChange ;
     FDataSource.OnStateChange := RedrawLabel ;
end ;

procedure TGLStateLabel.RedrawLabel(Sender : TObject) ;
begin
     Caption := aStates[FDataSource.State] ;
     if Assigned(FPrevStateChange) then FPrevStateChange(FDataSource);
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Database', [TGLStateLabel]);
end;

end.
