unit savegrid;

{$DEFINE USE_INIFILE}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids,
  {$IFDEF USE_INIFILE}
  IniFiles
  {$ELSE}
  WinReg   { for TWinRegistry }
  {$ENDIF}
  ;

type
  TGLDBSGrid = class(TDBGrid)
  private
     FAutoLoad : boolean ;
     FAutoSave : boolean ;
     {$IFDEF USE_INIFILE}
     FIniFile : TIniFile ;
     FIniFileName : string ;
     {$ELSE}
     FIniFile : TWinRegistry ;
     FRegistryKey : string ;
     {$ENDIF}
  protected
     procedure CreateWnd ; override ;
  public
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
     procedure ClearSettings ;
     procedure Load ;
     procedure Save ;
  published
     property AutoLoad : boolean read FAutoLoad
                                 write FAutoLoad default False ;
     property AutoSave : boolean read FAutoSave
                                 write FAutoSave default True ;
     {$IFDEF USE_INIFILE}
     property IniFileName : string read FiniFileName
                                   write FiniFileName ;
     {$ELSE}
     property RegistryKey : string read FRegistryKey
                                   write FRegistryKey ;
     {$ENDIF}
  end;

{$IFNDEF USE_INIFILE}

const
     MAIN_REGISTRY_KEY = 'Software' ;
     SECTION = 'Greg Lief' ;

{$ENDIF}


procedure Register;

implementation

constructor TGLDBSGrid.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FAutoLoad := False ;
     FAutoSave := True ;
     {$IFDEF USE_INIFILE}
     FIniFileName := Name + '.ini' ;
     {$ELSE}
     FRegistryKey := Name ;
     {$ENDIF}
end ;

procedure TGLDBSGrid.CreateWnd ;
begin
     inherited CreateWnd ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLDBSGrid 1.0 - Copyright  1998 Greg Lief' + #13 + 'This component is part of the G.L.A.D. collection' + #13 + 'To remove this message and receive the source code, ' + #13 + 'register at http://www.greglief.com/delphi.shtml',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
     if FAutoLoad then Load ;
end ;

procedure TGLDBSGrid.Load ;
var
   x : integer ;
begin
     {$IFDEF USE_INIFILE}
     FIniFile := TIniFile.Create(ExtractFilePath(ParamStr(0)) + FIniFileName) ;
     if FileExists(ExtractFilePath(ParamStr(0)) + FIniFileName) then begin
     {$ELSE}
     FIniFile := TWinRegistry.Create(MAIN_REGISTRY_KEY+ '\' + SECTION + '\' + FRegistryKey) ;
     { there must be a cleaner way to test for the
       existence of a key -- if you find it, let me know }
     if (FIniFile.ReadString('Column0','FieldName','<none>') <> '<none>') then begin
     {$ENDIF}
        x := 0 ;
        Columns.Clear ;
        while (x < 1000) and
           (FIniFile.ReadString('Column' + IntToStr(x),'Fieldname', '???') <> '???') do begin
           Columns.Add ;
           Columns[x].FieldName := FIniFile.ReadString('Column' + IntToStr(x),
                                   'Fieldname',
                                   Columns[x].FieldName) ;
           Columns[x].Width :=  FIniFile.ReadInteger('Column' + IntToStr(x),
                                'Width', Columns[x].Width) ;
           Columns[x].Title.Caption := FIniFile.ReadString('Column' + IntToStr(x),
                                'Title', Columns[x].Title.Caption) ;
           Columns[x].Color := FIniFile.ReadInteger('Column' + IntToStr(x),
                                'Color', Columns[x].Color) ;
           Inc(x) ;
        end ;
     end ;
     FIniFile.Free ;
end ;

procedure TGLDBSGrid.Save ;
var
   x : integer ;
begin
     {$IFDEF USE_INIFILE}
     FIniFile := TIniFile.Create(ExtractFilePath(ParamStr(0)) + FIniFileName) ;
     {$ELSE}
     FIniFile := TWinRegistry.Create(MAIN_REGISTRY_KEY + '\' + SECTION + '\' + FRegistryKey) ;
     {$ENDIF}
     for x := 0 to Columns.Count - 1 do begin
        FIniFile.WriteString('Column' + IntToStr(x),
                             'Fieldname',
                             Columns[x].FieldName) ;
        FIniFile.WriteInteger('Column' + IntToStr(x),
                              'Width',
                              Columns[x].Width) ;
        FIniFile.WriteString('Column' + IntToStr(x),
                             'Title',
                             Columns[x].Title.Caption) ;
        FIniFile.WriteInteger('Column' + IntToStr(x),
                              'Color',
                              Columns[x].Color) ;
     end ;
     FIniFile.Free ;
end ;


procedure TGLDBSGrid.ClearSettings ;
begin
     {$IFDEF USE_INIFILE}
     DeleteFile(ExtractFilePath(ParamStr(0)) + FIniFileName) ;
     {$ELSE}
     FIniFile := TWinRegistry.Create(MAIN_REGISTRY_KEY+ '\' + SECTION) ;
     FIniFile.EraseSection(FRegistryKey) ;
     FIniFile.Free ;
     {$ENDIF}
end ;


destructor TGLDBSGrid.Destroy ;
begin
     if FAutoSave then Save ;
     inherited Destroy ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: DBGrids', [TGLDBSGrid]);
end;

end.
