unit repeater;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons,
  ExtCtrls { for TTimer -- added manually } ;

type
  TGLRepeatButton = class(TSpeedButton)
  private
    FTimer : TTimer ;
    function GetInterval : integer ;
    procedure SetInterval(i : integer) ;
  protected
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override ;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override ;
  public
    constructor Create(AOwner : TComponent) ; override ;
    destructor Destroy ; override ;
  published
    property Interval : integer read GetInterval write SetInterval default 1000 ;
  end;

procedure Register;

implementation

constructor TGLRepeatButton.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FTimer := TTimer.Create(self) ;
     FTimer.Enabled := False ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLRepeatButton 1.0 - Copyright  1998 Greg Lief' + #13 + 'This component is part of the G.L.A.D. collection' + #13 + 'To remove this message and receive the source code, ' + #13 + 'register at http://www.greglief.com/delphi.shtml',
                   mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

destructor TGLRepeatButton.Destroy ;
begin
     FTimer.Free ;
     inherited Destroy ;
end ;

procedure TGLRepeatButton.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     inherited MouseDown(Button, Shift, X, Y) ;
     {$IFDEF WIN32}
     if (Button = mbLeft) and Assigned(OnClick) then begin
     {$ELSE}
     if (Button = mbLeft) then begin
     {$ENDIF}
        FTimer.OnTimer := OnClick ;
        FTimer.Enabled := True ;
     end ;
end ;

procedure TGLRepeatButton.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     inherited MouseUp(Button, Shift, X, Y) ;
     if Button = mbLeft then
        FTimer.Enabled := False ;
end ;

function TGLRepeatButton.GetInterval : integer ;
begin
     Result := FTimer.Interval ;
end ;

procedure TGLRepeatButton.SetInterval(i : integer) ;
begin
     FTimer.Interval := i ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Interface', [TGLRepeatButton]);
end;

end.
