unit dbsg ;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids,
  DBTables  { added manually for access to TTable } ;

type
  TGLDBSortGrid = class ;

  TResortEvent = procedure (Grid : TGLDBSortGrid ; ColumnIndex : integer ) of object ;

  TGLDBSortGrid = class(TDBGrid)
  private
     FOnResort : TResortEvent ;
     FSelectedColor : TColor ;
     FOldColor : TColor ;
     FLastColumn : integer ;
  protected
     procedure CreateWnd ; override ;
     procedure WMLButtonDblClk(var Message: TWMLButtonDblClk); message WM_LBUTTONDBLCLK ;
  public
     constructor Create(AOwner : TComponent) ; override ;
  published
     property SelectedColor : TColor read FSelectedColor write FSelectedColor default clRed ;
     property OnResort : TResortEvent read FOnResort write FOnResort ;
  end;

procedure Register;

implementation

constructor TGLDBSortGrid.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FLastColumn := -1 ;
     { if the ColumnResize option is enabled, the column heading
       will flash annoyingly when you double-click upon it }
     Options := Options - [dgColumnResize] ;
     FSelectedColor := clRed ;
end ;

procedure TGLDBSortGrid.CreateWnd ;
begin
     inherited CreateWnd ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLDBSortGrid 1.03 - Copyright  1998 Greg Lief' + #13 + 'This component is part of the G.L.A.D. collection' + #13 + 'To remove this message and receive the source code, ' + #13 + 'register at http://www.greglief.com/delphi.shtml',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

procedure TGLDBSortGrid.WMLButtonDblClk(var Message: TWMLButtonDblClk);
var
   cell : TGridCoord ;
   OldCursor : TCursor ;
   OldSQLText : string ;
   ptr : integer ;
   FldName : string ;
   x : integer ;
begin
     OldCursor := Screen.Cursor ;
     Cell := MouseCoord(Message.XPos, Message.YPos) ;
     if Cell.Y = 0 then begin
        if dgIndicator in Options then Dec(Cell.X) ;
        if Cell.X <> FLastColumn then begin
           try
              Screen.Cursor := crHourglass ;
              if DataSource.DataSet is TTable then begin
                 x := 0 ;
                 with TTable(DataSource.DataSet) do begin

{$IFDEF WIN32}  { use Grid's Columns property for Delphi 2 and 3 }

                    while (x < IndexDefs.Count) and
                          (UpperCase(Columns[Cell.X].FieldName) <> UpperCase(IndexDefs[x].Fields)) do

{$ELSE}         { for Delphi 1 we are stuck with the field objects }

                    while (x < IndexDefs.Count) and
                          (UpperCase(Fields[Cell.X].FieldName) <> UpperCase(IndexDefs[x].Fields)) do
{$ENDIF}

                       Inc(x) ;
                    if x < IndexDefs.Count then
                       IndexName := IndexDefs[x].Name
                    else
                       abort ;
                 end ;
              end
              else
                 {$IFDEF WIN32}
                 with DataSource.DataSet as TQuery do begin
                    FldName := Fields[Cell.X].FieldName ;
                    DisableControls ;
                    Close ;
                    OldSQLText := SQL.Text ;
                    ptr := Pos('ORDER BY', UpperCase(SQL.Text)) ;
                    if ptr > 0 then
                       SQL.Text := Copy(SQL.Text, 1, ptr - 1) ;
                    SQL.Add('ORDER BY ' + FldName) ;
                    Open ;
                    EnableControls ;
                 end
                 {$ENDIF}
                 ;
              Screen.Cursor := OldCursor ;
              {$IFDEF WIN32}
              if FLastColumn <> -1 then begin
                 Columns[FLastColumn].Title.Font.Style := Columns[FLastColumn].Title.Font.Style - [fsBold] ;
                 Columns[FLastColumn].Title.Font.Color := FOldColor ;
              end ;
              Columns[Cell.x].Title.Font.Style := Columns[Cell.x].Title.Font.Style + [fsBold] ;
              FOldColor := Columns[Cell.x].Title.Font.Color ;
              Columns[Cell.x].Title.Font.Color := FSelectedColor ;
              {$ENDIF}
              FLastColumn := Cell.x ;
              if Assigned(FOnResort) then
                 FOnResort(self, Cell.X) ;
           except
              Screen.Cursor := OldCursor ;
              MessageDlg('Cannot sort on this column', mtError, [mbOK], 0) ;
              {$IFDEF WIN32}
              if OldSQLText <> '' then
                 with DataSource.DataSet as TQuery do begin
                    SQL.Text := OldSQLText ;
                    Open ;
                    EnableControls ;
                 end ;
              {$ENDIF}
           end ;
        end ;
     end
     else
        DblClick ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: DBGrids', [TGLDBSortGrid]);
end;

end.
