unit dbproped ;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinTypes, WinProcs,
  {$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls,
  DBCtrls ;

type
  TGLDBProperEdit = class(TDBEdit)
  private
    FEnabled : boolean ;
    ForceUpper : boolean ;
  protected
    procedure KeyPress(var Key: Char); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override ;
  public
    constructor Create(AOwner : TComponent) ; override ;
  published
    property Enabled : boolean read FEnabled write FEnabled default True ;
  end;

procedure Register;

implementation

const
     Separators = ' -' + #39 + ',."' ;

constructor TGLDBProperEdit.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FEnabled := True ;
     ForceUpper := True ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLDBProperEdit 1.0 - Copyright  1998 Greg Lief' + #13 +
                   'This component is part of the G.L.A.D. collection' + #13 +
                   'To remove this message and receive the source code, ' + #13 +
                   'register at http://www.greglief.com/delphi.shtml',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

procedure TGLDBProperEdit.KeyPress(var Key: Char);
var
   x : integer ;
begin
     inherited KeyPress(Key) ;
     if FEnabled then begin
        x := Ord(Key) ;
        if (x >= 32) and (x <= 255) then
           if Pos(Key, Separators) > 0 then
              ForceUpper := True
           else if x > 64 then
              if ForceUpper then begin
                 { if the next character should be upper but they
                   entered an upper, switch case to lower }
                 if (x < 91) then
                    Key := Chr(x + 32)
                 else
                    Key := Chr(x - 32) ;
                 ForceUpper := False ;
              end ;
     end ;
end ;

procedure TGLDBProperEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
     inherited KeyDown(Key, Shift) ;
     if FEnabled then begin
        ForceUpper := (SelStart = 0) or
                   (Pos( Copy(Text, SelStart, 1), Separators) > 0) or
                   (Copy(Text, SelStart - 1, 2) = 'Mc') or
                   (Copy(Text, SelStart - 2, 3) = 'Mac') ;
     end ;
end;

procedure Register;
begin
  RegisterComponents('GLAD: Database', [TGLDBProperEdit]);
end;

end.
