unit srchedit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  DBTables, { for TTable }
  DB,
  DsgnIntf  { for property editor-related things } ;

type
  TMyFieldName = string[100] ;

  TMyFieldNameEditor = Class(TStringProperty)
    function  GetAttributes : TPropertyAttributes; override;
    procedure GetValues(Proc : TGetStrProc) ;      override;
  end;

  TGLSearchEdit = class(TEdit)
  private
     FBeepOnBadKey : boolean ;
     FDataSet : TDataSet ;
     FFieldName : TMyFieldName ;
     FFilterActive : boolean ;
  protected
     procedure Change ; override ;
     procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent) ; override ;
  published
     property BeepOnBadKey : boolean read FBeepOnBadKey write FBeepOnBadKey default False ;
     property DataSet : TDataSet read FDataSet write FDataSet ;
     property FieldName : TMyFieldName read FFieldName write FFieldName ;
     property FilterActive : boolean read FFilterActive
                                     write FFilterActive default False ;
  end;

procedure Register;

implementation

constructor TGLSearchEdit.Create(AOwner: TComponent);
begin
     inherited ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLSearchEdit (1.01) - Copyright  1998 Greg Lief' + #13 + 'This component is part of the G.L.A.D. collection' + #13 + 'To remove this message and receive the source code, ' + #13 + 'register at http://www.greglief.com/delphi.shtml',
                   mtInformation, [mbOK], 0) ;
{$ENDIF}
end;

procedure TGLSearchEdit.Notification(AComponent: TComponent; Operation: TOperation);
begin
   if (Operation = opRemove) and (AComponent = FDataSet) then
      FFieldName := '' ;
end ;

procedure TGLSearchEdit.Change ;
var
   NoFind : boolean ;
begin
     inherited ;
     if (FDataSet <> nil) and (FDataSet.Active) and (FFieldName <> '') then begin
        with FDataSet do
           if Text = '' then begin
              NoFind := False ;
              First ;
           end
           else if FFilterActive then begin
              FilterOptions := [foCaseInsensitive] ;
              Filter := FFieldName + '=' + QuotedStr(Text + '*') ;
              Filtered := ( Text <> '' ) ;
              NoFind := FDataSet.EOF ;
           end
           else
              NoFind := not Locate(FFieldName, Text,
                            [loCaseInsensitive, loPartialKey]) ;
        if NoFind then begin
           if FBeepOnBadKey then MessageBeep(0) ;
           Text := Copy(Text, 1, Length(Text) - 1) ;
           SelStart := Length(Text) ;
        end ;
     end ;
end ;

function TMyFieldNameEditor.GetAttributes : TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paValueList,paSortList] ;
end;

procedure TMyFieldNameEditor.GetValues(Proc: TGetStrProc);
var
  x : integer ;
begin
     with (GetComponent(0) as TGLSearchEdit).FDataSet do begin
        FieldDefs.Update ;
        for x := 0 to FieldDefs.Count - 1 do
           Proc(FieldDefs[x].Name) ;
     end ;
end;

procedure Register;
begin
  RegisterComponents('GLAD: Database', [TGLSearchEdit]);
  RegisterPropertyEditor( TypeInfo(TMyFieldName), TGLSearchEdit, 'FieldName', TMyFieldNameEditor);
end;

end.
