unit Terrlog;

interface

{$DEFINE SHOW_DIALOG}

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs
  {$IFDEF SHOW_DIALOG}
    {$IFDEF WIN32}
    , ErrFrm32 
    {$ELSE}
    , ErrorFrm
    {$ENDIF}
  {$ENDIF}
  ;

type
  TGLLogInfoEvent = procedure (Sender : TObject ; var ExtraInfo : TStringList) of object ;

  TGLErrorLogger = class(TComponent)
  private
     FLogDir : string ;
     FLogFile : string ;
     FExtraLogInfo : TGLLogInfoEvent ;
     FTerminateOnError : boolean ;
  public
     constructor Create(AOwner : TComponent) ; override ;
     procedure GlobalHandler(Sender: TObject; E: Exception);
  published
     property ExtraLogInfo : TGLLogInfoEvent read FExtraLogInfo
                                             write FExtraLogInfo ;
     property LogDir : string read FLogDir write FLogDir ;
     property LogFile : string read FLogFile write FLogFile ;
     property TerminateOnError : boolean read FTerminateOnError
                                 write FTerminateOnError default False ;
  end;

procedure Register;

implementation

constructor TGLErrorLogger.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FLogFile := 'error.log' ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLErrorLogger (1.02) - Copyright  1998 Greg Lief' + #13 + 'This component is part of the G.L.A.D. collection' + #13 + 'To remove this message and receive the source code, ' + #13 + 'register at http://www.greglief.com/delphi.shtml',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
     if not (csDesigning in ComponentState) then
        Application.OnException := GlobalHandler ;
end ;

procedure TGLErrorLogger.GlobalHandler(Sender: TObject; E: Exception);
var
{$IFDEF SHOW_DIALOG}
   f : TErrorForm ;
   UserNotes : TStringList ;
{$ENDIF}
   LogFile : TStringList;
   ExtraInfo : TStringList ;
   sFileName : string;
begin
{$IFDEF SHOW_DIALOG}
   f := TErrorForm.Create(nil) ;
   UserNotes := TStringList.Create ;
   f.ErrClassLabel.Caption := 'Error Class: ' + E.ClassName;
   f.ErrMsgLabel.Caption := E.Message;
   try
      f.ShowModal ;
      UserNotes.Assign( f.UserMemo.Lines ) ;
   finally
      f.Release ;
   end ;
{$ELSE}
   MessageDlg('Error: ' + E.ClassName + #13 + E.Message, mtError, [mbOK], 0) ;
{$ENDIF}
   if FLogDir = '' then FLogDir := ExtractFilePath(ParamStr(0)) ;
   sFileName := FLogDir + FLogFile ;
   LogFile := TStringList.Create;
   try
      if FileExists(sFileName) then LogFile.LoadFromFile(sFileName);
      LogFile.Add( 'Application Error at ' + FormatDateTime('hh:nn am/pm', Now)
         + ' on ' + FormatDateTime('mm/dd/yy', Now));
      LogFile.Add('Error Class: ' + E.ClassName);
      LogFile.Add('Error Message: ' + E.Message);
      {$IFDEF SHOW_DIALOG}
      if UserNotes.Count > 0 then begin
         LogFile.Add('') ;
         LogFile.Add('User Notes:');
         LogFile.AddStrings(UserNotes);
      end ;
      UserNotes.Free ;
      {$ENDIF}
      if Assigned(FExtraLogInfo) then begin
         ExtraInfo := TStringList.Create ;
         FExtraLogInfo(self, ExtraInfo) ;
         if ExtraInfo.Count > 0 then
            LogFile.AddStrings(ExtraInfo) ;
         ExtraInfo.Free ;
      end ;
      LogFile.Add(StringOfChar('=',79)) ;
      LogFile.SaveToFile(sFileName);
   finally
      LogFile.Free;
   end;
   if FTerminateOnError then Application.Terminate ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Misc.', [TGLErrorLogger]);
end;

end.
