unit mlhgrid;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids;

type
  TGLMLHeadingGrid = class(TDBGrid)
  private
     FHeadingHeight : integer ;
     procedure SetHeadingHeight(i : integer) ;
  protected
     procedure CreateWnd ; override ;
     procedure DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState); override ;
  public
     constructor Create(AOwner : TComponent) ; override ;
  published
     property HeadingHeight : integer read FHeadingHeight write SetHeadingHeight ;
  end;

procedure Register;

implementation

constructor TGLMLHeadingGrid.Create(AOwner : TComponent) ;
begin
     inherited ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLMLHeadingGrid - Copyright  1998 Greg Lief' + #13 + 'This component is part of the G.L.A.D. collection' + #13 + 'To remove this message and receive the source code, ' + #13 + 'register at http://www.greglief.com/delphi.shtml',
                   mtInformation, [mbOK], 0)
{$ENDIF}
end ;

procedure TGLMLHeadingGrid.SetHeadingHeight(i : integer) ;
begin
     FHeadingHeight := i ;
     RowHeights[0] := FHeadingHeight ;
end ;

procedure TGLMLHeadingGrid.CreateWnd ;
begin
     inherited ;
     if not (csDesigning in ComponentState) then begin
        RowHeights[0] := FHeadingHeight ;
        // NOTE: there is no way to redraw column headings
        //       after columns are moved; therefore, it is
        //       best not to allow column moving at all
        Options := Options - [dgColumnResize] ;
     end ;
end ;

procedure TGLMLHeadingGrid.DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState);
var
   Text : string ;
   sTemp : string ;
   DelimiterPos : integer ;
   CurrentY : integer ;
   LeftOffset : integer ;
const
   MARGIN = 2 ;
begin
     inherited ;
     if (not (csDesigning in ComponentState)) and (gdFixed in AState) and (ARow = 0) and (ACol > 0) then begin
        Canvas.Brush.Color := FixedColor ;
        Canvas.FillRect(Rect(ARect.Left+MARGIN, ARect.Top+MARGIN,
                             ARect.Right-MARGIN, ARect.Bottom-MARGIN)) ;
        Text := Columns[ACol - 1].Title.Caption ;
        DelimiterPos := Pos(';', Text) ;
        CurrentY := ARect.Top + MARGIN ;
        LeftOffset := 0 ;  // just to keep the compiler from complaining
        while DelimiterPos > 0 do begin
           sTemp := Copy(Text, 1, DelimiterPos - 1) ;
{$IFDEF HANDLE_ALIGNMENT}
           case Columns[ACol - 1].Title.Alignment of
              taLeftJustify  : LeftOffset := ARect.Left + MARGIN ;
              taCenter       : LeftOffset := (ARect.Right - ARect.Left - Canvas.TextWidth(sTemp)) div 2 ;
              taRightJustify : LeftOffset := ARect.Right - MARGIN - Canvas.TextWidth(sTemp) ;
           end ;
{$ELSE}
           LeftOffset := ARect.Left + MARGIN ;
{$ENDIF}
           Canvas.TextOut(LeftOffset, CurrentY, sTemp) ;
           Text := Copy(Text, DelimiterPos + 1, Length(Text)) ;
           DelimiterPos := Pos(';', Text) ;
           Dec(CurrentY, Canvas.Font.Height - MARGIN) ;
        end ;
{$IFDEF HANDLE_ALIGNMENT}
        case Columns[ACol - 1].Title.Alignment of
           taLeftJustify  : LeftOffset := ARect.Left + MARGIN ;
           taCenter       : LeftOffset := (ARect.Right - ARect.Left - Canvas.TextWidth(sTemp)) div 2 ;
           taRightJustify : LeftOffset := ARect.Right - MARGIN - Canvas.TextWidth(sTemp) ;
        end ;
{$ELSE}
        LeftOffset := ARect.Left + MARGIN ;
{$ENDIF}
        Canvas.TextOut(LeftOffset, CurrentY, Text) ;
     end ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: DBGrids', [TGLMLHeadingGrid]);
end;

end.
